/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.concurrent.CyclicBarrier;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jgroups.util.DefaultTimeScheduler;
import org.jgroups.util.Promise;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.TimeScheduler2;
import org.jgroups.util.Util;

public class TimeSchedulerStressTest {
    final TimeScheduler timer;
    final int num_threads;
    final int num_tasks;
    final long task_duration;
    final CyclicBarrier barrier;
    final AtomicInteger total_tasks = new AtomicInteger(0);
    final AtomicInteger total_sched = new AtomicInteger(0);
    final AtomicInteger total_task_invocations = new AtomicInteger(0);
    static final int NUM_THREADS_IN_TIMER = 5;

    public TimeSchedulerStressTest(TimeScheduler timer, int num_threads, int num_tasks, long task_duration) {
        this.timer = timer;
        this.num_threads = num_threads;
        this.task_duration = task_duration;
        this.num_tasks = num_tasks;
        this.barrier = new CyclicBarrier(num_threads + 1);
    }

    public void start() throws Exception {
        MyThread[] threads = new MyThread[this.num_threads];
        for (int i = 0; i < threads.length; ++i) {
            threads[i] = new MyThread();
            threads[i].setName("thread-" + i);
            threads[i].start();
        }
        Util.sleep(1000L);
        System.out.println("starting " + threads.length + " threads");
        long start = System.currentTimeMillis();
        this.barrier.await();
        Reporter reporter = new Reporter();
        reporter.setDaemon(true);
        reporter.start();
        for (MyThread thread : threads) {
            thread.join();
        }
        long diff = System.currentTimeMillis() - start;
        this.timer.stop();
        System.out.println("Time: " + diff + " ms for " + this.total_tasks + " tasks");
        System.out.println("running tasks: " + this.timer.size() + ", total_sched: " + this.total_sched + ", completed: " + this.total_tasks + ", total task invocations: " + this.total_task_invocations);
    }

    public static void main(String[] args) throws Exception {
        int num_threads = 100;
        int num_tasks = 100;
        long task_duration = 50L;
        TimeScheduler timer = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals("-num_threads")) {
                num_threads = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-num_tasks")) {
                num_tasks = Integer.parseInt(args[++i]);
                continue;
            }
            if (args[i].equals("-task_duration")) {
                task_duration = Long.parseLong(args[++i]);
                continue;
            }
            if (args[i].equals("-type")) {
                String tmp;
                if ((tmp = args[++i]).equals("default")) {
                    timer = new DefaultTimeScheduler(5);
                    continue;
                }
                if (tmp.equals("new")) {
                    timer = new TimeScheduler2(5);
                    continue;
                }
                TimeSchedulerStressTest.help();
                return;
            }
            TimeSchedulerStressTest.help();
            return;
        }
        if (timer == null) {
            System.out.println("timer is null, using DefaultTimeScheduler with 5 threads");
            timer = new DefaultTimeScheduler(5);
        }
        TimeSchedulerStressTest test = new TimeSchedulerStressTest(timer, num_threads, num_tasks, task_duration);
        test.start();
    }

    static void help() {
        System.out.println("TimeSchedulerStressTest [-type <\"default\" | \"new\">] [-num_threads <num>] [-num_tasks <num>] [-task_duration <ms>]");
    }

    class MyTask
    implements Runnable {
        final Promise<Boolean> result = new Promise();

        MyTask() {
        }

        @Override
        public void run() {
            TimeSchedulerStressTest.this.total_task_invocations.incrementAndGet();
            this.result.setResult(true);
        }

        Boolean get() {
            return this.result.getResult();
        }
    }

    class Reporter
    extends Thread {
        Reporter() {
        }

        @Override
        public void run() {
            while (!TimeSchedulerStressTest.this.timer.isShutdown()) {
                System.out.println("running tasks: " + TimeSchedulerStressTest.this.timer.size() + ", total_sched: " + TimeSchedulerStressTest.this.total_sched + ", completed: " + TimeSchedulerStressTest.this.total_tasks + ", total task invocations: " + TimeSchedulerStressTest.this.total_task_invocations);
                Util.sleep(2000L);
            }
        }
    }

    class MyThread
    extends Thread {
        MyThread() {
        }

        @Override
        public void run() {
            try {
                TimeSchedulerStressTest.this.barrier.await();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            MyTask[] tasks = new MyTask[TimeSchedulerStressTest.this.num_tasks];
            for (int i = 0; i < TimeSchedulerStressTest.this.num_tasks; ++i) {
                tasks[i] = new MyTask();
                TimeSchedulerStressTest.this.timer.schedule(tasks[i], TimeSchedulerStressTest.this.task_duration, TimeUnit.MILLISECONDS);
                TimeSchedulerStressTest.this.total_sched.incrementAndGet();
            }
            for (MyTask task : tasks) {
                task.get();
                TimeSchedulerStressTest.this.total_tasks.incrementAndGet();
            }
        }
    }
}

