/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.tests;

import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import org.jgroups.Address;
import org.jgroups.View;
import org.jgroups.ViewId;
import org.jgroups.util.Util;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

@Test(groups={"functional"})
public class ViewTest {
    Address a;
    Address b;
    Address c;
    Address d;
    Address e;
    Address f;
    Address g;
    Address h;
    Address i;
    Address j;
    Address k;
    View view;
    List<Address> members;

    @BeforeClass
    public void setUp() throws Exception {
        this.c = this.b = (this.a = Util.createRandomAddress());
        this.d = Util.createRandomAddress();
        this.e = Util.createRandomAddress();
        this.f = Util.createRandomAddress();
        this.g = Util.createRandomAddress();
        this.h = Util.createRandomAddress();
        this.i = Util.createRandomAddress();
        ViewId id = new ViewId(this.a, 34L);
        this.members = Arrays.asList(this.a, this.b, this.d, this.e, this.f, this.g, this.h);
        this.view = new View(id, this.members);
    }

    public void testContainsMember() {
        assert (this.view.containsMember(this.a)) : "Member should be in view";
        assert (this.view.containsMember(this.b)) : "Member should be in view";
        assert (this.view.containsMember(this.c)) : "Member should be in view";
        assert (this.view.containsMember(this.d)) : "Member should be in view";
        assert (this.view.containsMember(this.e)) : "Member should be in view";
        assert (this.view.containsMember(this.f)) : "Member should be in view";
        assert (!this.view.containsMember(this.i)) : "Member should not be in view";
    }

    public void testEqualsCreator() {
        assert (this.a.equals(this.view.getCreator())) : "Creator should be a";
        assert (!this.view.getCreator().equals(this.d)) : "Creator should not be d";
    }

    public void testEquals() {
        assert (this.view.equals(this.view));
    }

    public void testEquals2() {
        View v1 = new View(new ViewId(this.a, 12345L), new Vector<Address>(this.members));
        View v2 = new View(this.a, 12345L, new Vector<Address>(this.members));
        assert (v1.equals(v2));
        View v3 = new View(this.a, 12543L, new Vector<Address>(this.members));
        assert (!v1.equals(v3));
    }

    public static void testEquals3() {
        View v1 = new View();
        View v2 = new View();
        assert (v1.equals(v2));
    }
}

