/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.monitor.alerts;

import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.management.Notification;
import javax.naming.InitialContext;
import org.jboss.monitor.JBossMonitorNotification;
import org.jboss.monitor.alerts.EmailAlertListenerMBean;
import org.jboss.monitor.alerts.JBossAlertListener;
import org.jboss.util.Strings;

public class EmailAlertListener
extends JBossAlertListener
implements EmailAlertListenerMBean {
    protected String messageTemplate;
    protected String subjectTemplate;
    protected String fromString;
    protected Address from;
    protected String replyToString;
    protected Address replyTo;
    protected Address[] to;
    protected HashSet toSet = new HashSet();

    public void handleNotification(Notification notification, Object handback) {
        if (!(notification instanceof JBossMonitorNotification)) {
            return;
        }
        Map substitutions = ((JBossMonitorNotification)notification).substitutionMap();
        String message = Strings.subst((String)this.messageTemplate, (Map)substitutions, (String)"%(", (String)")");
        String subject = Strings.subst((String)this.subjectTemplate, (Map)substitutions, (String)"%(", (String)")");
        try {
            Session session = (Session)new InitialContext().lookup("java:/Mail");
            Address[] replyToList = new Address[]{this.replyTo};
            MimeMessage newMessage = new MimeMessage(session);
            newMessage.setFrom(this.from);
            newMessage.setReplyTo(replyToList);
            newMessage.setRecipients(Message.RecipientType.TO, this.to);
            newMessage.setSubject(subject);
            newMessage.setSentDate(new Date());
            newMessage.setText(message);
            Transport transport = session.getTransport();
            transport.connect();
            transport.sendMessage((Message)newMessage, this.to);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public String getTo() {
        Iterator it = this.toSet.iterator();
        String output = "";
        while (it.hasNext()) {
            output = output + it.next();
            if (!it.hasNext()) continue;
            output = output + ",";
        }
        return output;
    }

    protected void updateTo() throws AddressException {
        Iterator it = this.toSet.iterator();
        Address[] newTo = new Address[this.toSet.size()];
        int i = 0;
        while (it.hasNext()) {
            String address = (String)it.next();
            newTo[i] = new InternetAddress(address);
            ++i;
        }
        this.to = newTo;
    }

    public void setTo(String t) throws AddressException {
        StringTokenizer tokenizer = new StringTokenizer(t, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken().trim();
            this.toSet.add(token);
        }
        this.updateTo();
    }

    public void addToAddress(String newAddress) throws AddressException {
        this.toSet.add(newAddress);
        this.updateTo();
    }

    public void removeToAddress(String removeAddress) throws AddressException {
        this.toSet.remove(removeAddress);
        this.updateTo();
    }

    public String getFrom() {
        return this.fromString;
    }

    public void setFrom(String f) throws AddressException {
        this.fromString = f;
        this.from = new InternetAddress(f);
    }

    public String getReplyTo() {
        return this.replyToString;
    }

    public void setReplyTo(String f) throws AddressException {
        this.replyToString = f;
        this.replyTo = new InternetAddress(f);
    }

    public String getMessageTemplate() {
        return this.messageTemplate;
    }

    public void setMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    public String getSubjectTemplate() {
        return this.subjectTemplate;
    }

    public void setSubjectTemplate(String messageTemplate) {
        this.subjectTemplate = messageTemplate;
    }
}

