/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.framework.deployment;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.jboss.logging.Logger;
import org.jboss.wsf.spi.deployment.DeploymentAspect;
import org.jboss.wsf.spi.deployment.DeploymentAspectManager;

public class DeploymentAspectInstaller {
    private static final Logger log = Logger.getLogger(DeploymentAspectInstaller.class);
    private DeploymentAspectManager manager;
    private Set<DeploymentAspect> aspects;
    private boolean sortAspectsOnCreate;
    private Set<String> parentProvidedConditions = new HashSet<String>();

    public void setManager(DeploymentAspectManager manager) {
        this.manager = manager;
    }

    public void setAspects(Set<DeploymentAspect> aspects) {
        this.aspects = aspects;
    }

    public void setSortAspectsOnCreate(boolean sortAspectsOnCreate) {
        this.sortAspectsOnCreate = sortAspectsOnCreate;
    }

    public void create() {
        ArrayList<DeploymentAspect> unsortedAspects = new ArrayList<DeploymentAspect>();
        unsortedAspects.addAll(this.manager.getDeploymentAspects());
        unsortedAspects.addAll(this.aspects);
        ArrayList<DeploymentAspect> sortedAspects = unsortedAspects;
        if (this.sortAspectsOnCreate) {
            DeploymentAspect aspect;
            if (this.manager.getParent() != null) {
                for (DeploymentAspect aspect2 : this.manager.getParent().getDeploymentAspects()) {
                    this.parentProvidedConditions.addAll(aspect2.getProvidesAsSet());
                }
            }
            sortedAspects = new ArrayList();
            ArrayList<DeploymentAspect> allAspects = new ArrayList<DeploymentAspect>(unsortedAspects);
            Iterator itAll = allAspects.iterator();
            while (itAll.hasNext()) {
                aspect = (DeploymentAspect)itAll.next();
                if (aspect.getRequires() != null && !this.parentProvidedConditions.containsAll(aspect.getRequiresAsSet())) continue;
                sortedAspects.add(aspect);
                itAll.remove();
            }
            itAll = allAspects.iterator();
            while (itAll.hasNext()) {
                aspect = (DeploymentAspect)itAll.next();
                int index = this.getAspectIndex(sortedAspects, aspect);
                if (index == -1) continue;
                sortedAspects.add(index, aspect);
                itAll.remove();
                itAll = allAspects.iterator();
            }
            itAll = allAspects.iterator();
            while (itAll.hasNext()) {
                aspect = (DeploymentAspect)itAll.next();
                if (!"LAST_DEPLOYMENT_ASPECT".equals(aspect.getRequires())) continue;
                sortedAspects.add(aspect);
                itAll.remove();
            }
            if (allAspects.size() != 0) {
                this.throwSortException(sortedAspects, allAspects);
            }
        }
        this.manager.setDeploymentAspects(sortedAspects);
    }

    public void destroy() {
        ArrayList managerAspects = new ArrayList();
        managerAspects.addAll(this.manager.getDeploymentAspects());
        for (DeploymentAspect aspect : this.aspects) {
            managerAspects.remove(aspect);
        }
        this.manager.setDeploymentAspects(managerAspects);
    }

    private void throwSortException(List<DeploymentAspect> sortedAspects, List<DeploymentAspect> allAspects) {
        HashSet providedConditions = new HashSet();
        for (int i = 0; i < sortedAspects.size(); ++i) {
            DeploymentAspect sortedAspect = sortedAspects.get(i);
            providedConditions.addAll(sortedAspect.getProvidesAsSet());
        }
        String exmsg = "Cannot add deployment aspect(s)";
        StringBuilder str = new StringBuilder(exmsg);
        if (this.manager.getParent() != null) {
            str.append("\n" + this.manager.getParent().getName() + " provides: " + this.parentProvidedConditions);
        }
        str.append("\n" + this.manager.getName() + " provides: " + providedConditions);
        for (DeploymentAspect da : allAspects) {
            str.append("\n   " + da.getClass().getName() + ", requires: " + da.getRequires());
        }
        log.error((Object)str);
        throw new IllegalStateException(str.toString());
    }

    private int getAspectIndex(List<DeploymentAspect> sortedAspects, DeploymentAspect aspect) {
        int index = -1;
        HashSet<String> providedConditions = new HashSet<String>(this.parentProvidedConditions);
        for (int i = 0; i < sortedAspects.size(); ++i) {
            DeploymentAspect sortedAspect = sortedAspects.get(i);
            providedConditions.addAll(sortedAspect.getProvidesAsSet());
            if (!providedConditions.containsAll(aspect.getRequiresAsSet())) continue;
            index = i + 1;
            break;
        }
        return index;
    }
}

