/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.beanvalidation.deployers;

import javax.naming.NamingException;
import javax.validation.ValidatorFactory;
import org.jboss.beanvalidation.util.JndiBinder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractSimpleRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValidatorFactoryJndiBinderDeployer
extends AbstractSimpleRealDeployer<ValidatorFactory> {
    private JndiBinder jndiBinder;

    public ValidatorFactoryJndiBinderDeployer(JndiBinder jndiBinder) {
        super(ValidatorFactory.class);
        if (jndiBinder == null) {
            throw new IllegalArgumentException("Null jndi binder");
        }
        this.setStage(DeploymentStages.PRE_REAL);
        this.addOutput(ValidatorFactory.class.getName() + ".JNDI_NAME");
        this.jndiBinder = jndiBinder;
    }

    public void deploy(DeploymentUnit unit, ValidatorFactory validatorFactory) throws DeploymentException {
        try {
            this.jndiBinder.bind(unit.getSimpleName(), validatorFactory);
        }
        catch (NamingException e) {
            throw DeploymentException.rethrowAsDeploymentException((String)"Cannot bind validator factory.", (Throwable)e);
        }
    }

    public void undeploy(DeploymentUnit unit, ValidatorFactory validatorFactory) {
        try {
            this.jndiBinder.unbind(unit.getSimpleName());
        }
        catch (NamingException e) {
            this.log.warn((Object)("Exception unbinding validator factory: " + e));
        }
    }
}

