/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.imr;

import org.jacorb.imr.ImRInfo;
import org.jacorb.imr.Registration;
import org.jacorb.imr.RegistrationHelper;
import org.jacorb.imr.RegistrationPackage.DuplicatePOAName;
import org.jacorb.imr.RegistrationPackage.IllegalPOAName;
import org.jacorb.imr.UnknownServerName;
import org.jacorb.orb.ImRAccess;
import org.jacorb.orb.etf.ProtocolAddressBase;
import org.jacorb.orb.iiop.IIOPAddress;
import org.omg.CORBA.INTERNAL;
import org.omg.CORBA.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.SystemException;

public class ImRAccessImpl
implements ImRAccess {
    private Registration reg = null;
    private ImRInfo info = null;

    private ImRAccessImpl() {
    }

    public static ImRAccessImpl connect(ORB oRB) {
        ImRAccessImpl imRAccessImpl = new ImRAccessImpl();
        try {
            imRAccessImpl.reg = RegistrationHelper.narrow(oRB.resolve_initial_references("ImplementationRepository"));
        }
        catch (InvalidName invalidName) {
            throw new INTERNAL("unable to resolve ImplementationRepository: " + invalidName.toString());
        }
        boolean bl = true;
        if (imRAccessImpl.reg != null) {
            try {
                bl = imRAccessImpl.reg._non_existent();
            }
            catch (SystemException systemException) {
                bl = true;
            }
        }
        if (bl) {
            throw new INTERNAL("Unable to resolve reference to ImR");
        }
        return imRAccessImpl;
    }

    public ProtocolAddressBase getImRAddress() {
        if (this.info == null) {
            this.info = this.reg.get_imr_info();
        }
        return new IIOPAddress(this.info.host, this.info.port);
    }

    public String getImRHost() {
        if (this.info == null) {
            this.info = this.reg.get_imr_info();
        }
        return this.info.host;
    }

    public int getImRPort() {
        if (this.info == null) {
            this.info = this.reg.get_imr_info();
        }
        return this.info.port;
    }

    public void registerPOA(String string, String string2, ProtocolAddressBase protocolAddressBase) throws INTERNAL {
        if (!(protocolAddressBase instanceof IIOPAddress)) {
            throw new INTERNAL("IMR only supports IIOP based POAs");
        }
        this.registerPOA(string, string2, ((IIOPAddress)protocolAddressBase).getHostname(), ((IIOPAddress)protocolAddressBase).getPort());
    }

    public void registerPOA(String string, String string2, String string3, int n) throws INTERNAL {
        try {
            this.reg.register_poa(string, string2, string3, n);
        }
        catch (DuplicatePOAName duplicatePOAName) {
            throw new INTERNAL("A server with the same combination of ImplName/POA-Name (" + string + ") is already registered and listed as active at the imr: " + duplicatePOAName.toString());
        }
        catch (IllegalPOAName illegalPOAName) {
            throw new INTERNAL("The ImR replied that the POA name >>" + illegalPOAName.name + "<< is illegal: " + illegalPOAName.toString());
        }
        catch (UnknownServerName unknownServerName) {
            throw new INTERNAL("The ImR replied that the server name >>" + unknownServerName.name + "<< is unknown: " + unknownServerName.toString());
        }
    }

    public void setServerDown(String string) throws INTERNAL {
        try {
            this.reg.set_server_down(string);
        }
        catch (UnknownServerName unknownServerName) {
            throw new INTERNAL("The ImR replied that a server with name " + string + " is unknown: " + unknownServerName.toString());
        }
    }
}

