/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.proxy.clustered.factory.session.stateful;

import java.io.Serializable;
import org.jboss.aop.Advisor;
import org.jboss.aop.Dispatcher;
import org.jboss.aop.advice.Interceptor;
import org.jboss.ejb3.proxy.clustered.factory.session.stateless.StatelessSessionClusteredProxyFactory;
import org.jboss.ejb3.proxy.clustered.handler.session.stateful.StatefulClusteredProxyInvocationHandler;
import org.jboss.ejb3.proxy.clustered.registry.ProxyClusteringInfo;
import org.jboss.ejb3.proxy.clustered.registry.ProxyClusteringRegistry;
import org.jboss.ejb3.proxy.impl.factory.session.stateful.StatefulSessionRemoteProxyFactory;
import org.jboss.ejb3.proxy.impl.handler.session.SessionProxyInvocationHandler;
import org.jboss.ha.client.loadbalance.LoadBalancePolicy;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;
import org.jboss.remoting.InvokerLocator;

public class StatefulSessionClusteredProxyFactory
extends StatefulSessionRemoteProxyFactory {
    private static final String STACK_NAME_CLUSTERED_STATEFUL_SESSION_CLIENT_INTERCEPTORS = "ClusteredStatefulSessionClientInterceptors";
    private static final Logger log = Logger.getLogger(StatelessSessionClusteredProxyFactory.class);
    private final ProxyClusteringRegistry registry;
    private ProxyClusteringInfo beanClusteringInfo;

    public StatefulSessionClusteredProxyFactory(String name, String containerName, String containerGuid, JBossSessionBeanMetaData metadata, ClassLoader classloader, String url, Advisor advisor, ProxyClusteringRegistry registry, String interceptorStack) {
        super(name, containerName, containerGuid, metadata, classloader, url, advisor, interceptorStack);
        assert (registry != null) : "registry is null";
        this.registry = registry;
    }

    protected String getDefaultInterceptorStackName() {
        return STACK_NAME_CLUSTERED_STATEFUL_SESSION_CLIENT_INTERCEPTORS;
    }

    public void start() throws Exception {
        super.start();
        this.beanClusteringInfo = this.registry.registerClusteredBean(this.getContainerName(), this.getName(), this.getMetadata(), new InvokerLocator(this.getUrl()));
        log.debug((Object)("Registering with Remoting Dispatcher under name \"" + this.getName() + "\": " + (Object)((Object)this)));
        Dispatcher.singleton.registerTarget((Object)this.getName(), (Object)this);
    }

    public void stop() throws Exception {
        this.registry.unregisterClusteredBean(this.beanClusteringInfo);
        log.debug((Object)("Unregistering name \"" + this.getName() + "\" from Remoting Dispatcher"));
        Dispatcher.singleton.unregisterTarget((Object)this.getName());
        super.stop();
    }

    protected SessionProxyInvocationHandler createBusinessDefaultInvocationHandler(Serializable sessionId) {
        return this.createInvocationHandler(null, false, sessionId);
    }

    protected SessionProxyInvocationHandler createBusinessInterfaceSpecificInvocationHandler(Serializable sessionId, String businessInterfaceName) {
        return this.createInvocationHandler(businessInterfaceName, false, sessionId);
    }

    protected SessionProxyInvocationHandler createEjb2xComponentInterfaceInvocationHandler(Serializable sessionId) {
        return this.createInvocationHandler(null, false, sessionId);
    }

    protected SessionProxyInvocationHandler createHomeInvocationHandler() {
        return this.createInvocationHandler(null, true, null);
    }

    private SessionProxyInvocationHandler createInvocationHandler(String businessInterfaceName, boolean isOnlyHome, Serializable sessionId) {
        LoadBalancePolicy lbp;
        String containerName = this.getContainerName();
        String url = this.getUrl();
        String containerGuid = this.getContainerGuid();
        Interceptor[] interceptors = this.getInterceptors();
        Class<? extends LoadBalancePolicy> policyClass = isOnlyHome ? this.beanClusteringInfo.getHomeLoadBalancePolicy() : this.beanClusteringInfo.getLoadBalancePolicy();
        try {
            lbp = policyClass.newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("Cannot instantiate LoadBalancePolicy class " + policyClass);
        }
        StatefulClusteredProxyInvocationHandler handler = new StatefulClusteredProxyInvocationHandler(containerName, containerGuid, interceptors, businessInterfaceName, sessionId, url, this.beanClusteringInfo.getFamilyWrapper(), lbp, this.beanClusteringInfo.getPartitionName());
        return handler;
    }
}

