/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode.accessor.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import org.jboss.reflect.plugins.bytecode.accessor.metrics.MetricsMBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Metrics
implements MetricsMBean {
    static final List<Entry> record = new ArrayList<Entry>();
    final Entry entry;
    volatile boolean locked;

    public Metrics() {
        this.entry = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Metrics(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Null name");
        }
        this.entry = new Entry(name);
        List<Entry> list = record;
        synchronized (list) {
            record.add(this.entry);
        }
    }

    static String getDelegateType(Object delegate) {
        if (delegate.getClass().getSimpleName().startsWith("Default")) {
            return " - {R}";
        }
        return " - {G}";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void recordTime(long nanosTaken) {
        if (this.locked) {
            List<Entry> list = record;
            synchronized (list) {
                this.doRecordTime(nanosTaken);
            }
        }
        this.doRecordTime(nanosTaken);
    }

    protected void doRecordTime(long nanosTaken) {
        this.entry.getInvocations().incrementAndGet();
        this.entry.getNanos().addAndGet(nanosTaken);
    }

    @Override
    public List<Entry> sortByInvocations() {
        return this.sort(InvocationsComparator.INSTANCE);
    }

    @Override
    public String outputEntriesByInvocations(String lineSeparator) {
        if (lineSeparator == null) {
            lineSeparator = "\n";
        }
        StringBuilder sb = new StringBuilder("Invocations (total time in ms) - Member name");
        sb.append(lineSeparator);
        sb.append("============================================");
        sb.append(lineSeparator);
        long totalTime = 0L;
        long invocations = 0L;
        for (Entry entry : this.sortByInvocations()) {
            totalTime += entry.getNanos().get();
            invocations += (long)entry.getInvocations().get();
            sb.append(entry.getInvocations() + " (" + entry.getNanos().get() + ") - " + entry.getName());
            sb.append(lineSeparator);
        }
        sb.append("--------------------------------------------");
        sb.append(lineSeparator);
        sb.append("Total: " + invocations + " (" + totalTime + ")");
        return sb.toString();
    }

    @Override
    public List<Entry> sortByTime() {
        return this.sort(TimeComparator.INSTANCE);
    }

    @Override
    public String outputEntriesByTime(String lineSeparator) {
        if (lineSeparator == null) {
            lineSeparator = "\n";
        }
        StringBuilder sb = new StringBuilder("Total time in ms (Invocations) - Member name");
        sb.append(lineSeparator);
        sb.append("=============================================");
        sb.append(lineSeparator);
        long totalTime = 0L;
        long invocations = 0L;
        for (Entry entry : this.sortByTime()) {
            totalTime += entry.getNanos().get();
            invocations += (long)entry.getInvocations().get();
            sb.append(entry.getNanos().get() + " (" + entry.getInvocations() + ") - " + entry.getName());
            sb.append(lineSeparator);
        }
        sb.append("--------------------------------------------");
        sb.append(lineSeparator);
        sb.append("Total: " + totalTime + " (" + invocations + ")");
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<Entry> sort(Comparator<Entry> comparator) {
        List<Entry> list = record;
        synchronized (list) {
            ArrayList<Entry> arrayList;
            try {
                this.locked = true;
                ArrayList<Entry> entries = new ArrayList<Entry>(record);
                Collections.sort(entries, comparator);
                arrayList = entries;
                this.locked = false;
            }
            catch (Throwable throwable) {
                this.locked = false;
                throw throwable;
            }
            return arrayList;
        }
    }

    public static class Entry {
        final String name;
        final AtomicInteger invocations = new AtomicInteger();
        final AtomicLong nanos = new AtomicLong();

        public Entry(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public AtomicInteger getInvocations() {
            return this.invocations;
        }

        public AtomicLong getNanos() {
            return this.nanos;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TimeComparator
    implements Comparator<Entry> {
        static final TimeComparator INSTANCE = new TimeComparator();

        private TimeComparator() {
        }

        @Override
        public int compare(Entry o1, Entry o2) {
            if (o1.getNanos().get() == o2.getNanos().get()) {
                return 0;
            }
            if (o1.getNanos().get() > o2.getNanos().get()) {
                return -1;
            }
            return 1;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class InvocationsComparator
    implements Comparator<Entry> {
        static final InvocationsComparator INSTANCE = new InvocationsComparator();

        private InvocationsComparator() {
        }

        @Override
        public int compare(Entry o1, Entry o2) {
            if (o1.getInvocations().get() == o2.getInvocations().get()) {
                return 0;
            }
            if (o1.getInvocations().get() > o2.getInvocations().get()) {
                return -1;
            }
            return 1;
        }
    }
}

