/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode.accessor.reflect;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.lang.reflect.ReflectPermission;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import org.jboss.reflect.plugins.bytecode.accessor.FieldAccessor;
import org.jboss.reflect.plugins.introspection.ReflectionUtils;

class ReflectFieldAccessor
implements FieldAccessor {
    final Field field;
    private static Permission accessCheck = new ReflectPermission("suppressAccessChecks");

    ReflectFieldAccessor(Field field) {
        this.field = field;
        if (!Modifier.isPublic(field.getModifiers()) && field != null) {
            this.setAccessible();
        }
    }

    public Object get(Object target) throws Throwable {
        return ReflectionUtils.getField(this.field, target);
    }

    public void set(Object target, Object value) throws Throwable {
        ReflectionUtils.setField(this.field, target, value);
    }

    protected final void accessCheck() {
        this.accessCheck(Modifier.isPublic(this.field.getModifiers()));
    }

    protected final void accessCheck(boolean isPublic) {
        SecurityManager sm;
        if (!isPublic && (sm = System.getSecurityManager()) != null) {
            sm.checkPermission(accessCheck);
        }
    }

    private void setAccessible() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            this.field.setAccessible(true);
        } else {
            AccessController.doPrivileged(new SetAccessible());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetAccessible
    implements PrivilegedAction<Object> {
        private SetAccessible() {
        }

        @Override
        public Object run() {
            ReflectFieldAccessor.this.field.setAccessible(true);
            return null;
        }
    }
}

