/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.bytecode.bytes.asm;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import org.jboss.reflect.plugins.bytecode.bytes.ClassBytes;
import org.jboss.reflect.plugins.bytecode.bytes.ConstructorBytes;
import org.jboss.reflect.plugins.bytecode.bytes.FieldBytes;
import org.jboss.reflect.plugins.bytecode.bytes.MethodBytes;
import org.jboss.reflect.plugins.bytecode.bytes.PrimitiveBytes;
import org.jboss.reflect.plugins.bytecode.bytes.asm.AsmClassBytes;
import org.jboss.util.JBossObject;
import org.jboss.util.JBossStringBuilder;

class AsmArrayBytes
extends JBossObject
implements ClassBytes {
    static final String[] INTERFACE_TYPE_INFO_NAMES = new String[]{Cloneable.class.getName(), Serializable.class.getName()};
    static final String[] INTERFACE_JVM_NAMES = new String[]{Cloneable.class.getName().replace('.', '/'), Serializable.class.getName().replace('.', '/')};
    private final ClassBytes componentType;

    public AsmArrayBytes(ClassBytes componentType) {
        this.componentType = componentType;
    }

    public String getJvmName() {
        if (this.componentType.getComponentType() == null) {
            return "[L" + this.componentType.getJvmName() + ";";
        }
        return "[" + this.componentType.getJvmName();
    }

    public String getTypeInfoName() {
        return this.componentType.getTypeInfoName() + "[]";
    }

    public ClassLoader getClassLoader() {
        return this.componentType.getClassLoader();
    }

    public ClassBytes getComponentType() {
        return this.componentType;
    }

    public ConstructorBytes[] getDeclaredConstructorBytes() {
        return AsmClassBytes.NO_CONSTRUCTORS;
    }

    public FieldBytes[] getDeclaredFieldBytes() {
        return AsmClassBytes.NO_FIELDS;
    }

    public MethodBytes[] getDeclaredMethodBytes() {
        return AsmClassBytes.NO_METHODS;
    }

    public String[] getInterfaceJvmNames() {
        return INTERFACE_JVM_NAMES;
    }

    public String[] getInterfaceTypeInfoNames() {
        return INTERFACE_JVM_NAMES;
    }

    public String getSuperClassJvmName() {
        return "java/lang/Object";
    }

    public String getSuperClassTypeInfoName() {
        return "java.lang.Object";
    }

    public boolean isAnnotation() {
        return false;
    }

    public boolean isEnum() {
        return false;
    }

    public boolean isInterface() {
        return false;
    }

    public Annotation[] getAnnotations() {
        return null;
    }

    public String getGenericSignature() {
        return null;
    }

    public int getModifiers() {
        return 0;
    }

    public PrimitiveBytes getPrimitive() {
        return null;
    }

    public void toShortString(JBossStringBuilder buffer) {
        this.toShortString(buffer);
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append(this.getJvmName());
    }
}

