/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.introspection;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import org.jboss.reflect.plugins.ConstructorInfoImpl;
import org.jboss.reflect.plugins.introspection.ReflectionUtils;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.ParameterInfo;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ReflectConstructorInfoImpl
extends ConstructorInfoImpl {
    private static final long serialVersionUID = 2L;
    protected volatile transient Constructor<?> constructor;

    public ReflectConstructorInfoImpl() {
    }

    public ReflectConstructorInfoImpl(AnnotationValue[] annotations, TypeInfo[] parameterTypes, AnnotationValue[][] parameterAnnotations, ClassInfo[] exceptionTypes, int modifiers, ClassInfo declaring) {
        super(annotations, parameterTypes, parameterAnnotations, exceptionTypes, modifiers, declaring);
    }

    public ReflectConstructorInfoImpl(AnnotationValue[] annotations, ParameterInfo[] parameters, ClassInfo[] exceptionTypes, int modifiers, ClassInfo declaring) {
        super(annotations, parameters, exceptionTypes, modifiers, declaring);
    }

    public Constructor<?> getConstructor() {
        if (this.constructor == null) {
            this.initConstructor();
        }
        return this.constructor;
    }

    @Override
    public Object newInstance(Object[] args) throws Throwable {
        if (this.constructor == null) {
            this.initConstructor();
        }
        return ReflectionUtils.newInstance(this.constructor, args);
    }

    protected synchronized void initConstructor() {
        if (this.constructor != null) {
            return;
        }
        int length = this.parameterTypes != null ? this.parameterTypes.length : 0;
        Class[] classes = new Class[length];
        for (int i = 0; i < length; ++i) {
            classes[i] = this.parameterTypes[i].getType();
        }
        try {
            this.constructor = this.findConstructor(classes);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    private Constructor<?> findConstructor(final Class<?>[] classes) throws NoSuchMethodException {
        if (System.getSecurityManager() == null) {
            return ReflectionUtils.findExactConstructor(this.getDeclaringClass().getType(), classes);
        }
        try {
            return (Constructor)AccessController.doPrivileged(new PrivilegedExceptionAction<Constructor<?>>(){

                @Override
                public Constructor<?> run() throws Exception {
                    return ReflectionUtils.findExactConstructor(ReflectConstructorInfoImpl.this.getDeclaringClass().getType(), classes);
                }
            });
        }
        catch (PrivilegedActionException e) {
            if (e.getCause() instanceof NoSuchMethodException) {
                throw (NoSuchMethodException)e.getCause();
            }
            if (e.getCause() instanceof RuntimeException) {
                throw (RuntimeException)e.getCause();
            }
            throw new RuntimeException(e.getCause());
        }
    }
}

