/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtField;
import javassist.NotFoundException;
import javassist.bytecode.BadBytecode;
import javassist.bytecode.SignatureAttribute;
import org.jboss.reflect.plugins.javassist.JavassistClassInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeVariableSpy;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.reflect.spi.TypeInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JavassistHelper {
    static SignatureAttribute.ClassType determineType(ClassInfo clazz, ClassInfo search, int parameter) {
        Stack<ClassInfo> hierarchy = new Stack<ClassInfo>();
        try {
            JavassistHelper.determineHierarchy(hierarchy, clazz, search);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return JavassistHelper.determineType(hierarchy, parameter);
    }

    static TypeInfo determineInfoIndex(TypeInfo[] actualTypeArguments, ClassInfo clazz, ClassInfo search, int parameter) {
        Stack<ClassInfo> hierarchy = new Stack<ClassInfo>();
        try {
            JavassistHelper.determineHierarchy(hierarchy, clazz, search);
        }
        catch (NotFoundException e) {
            throw new RuntimeException(e);
        }
        return actualTypeArguments[JavassistHelper.determineInfoIndex(actualTypeArguments, hierarchy, parameter)];
    }

    static String getGenericName(SignatureAttribute.ObjectType type, JavassistTypeVariableSpy spy) {
        StringBuilder sb = new StringBuilder();
        JavassistHelper.appendTypeGenericInfo(type, spy, sb, null);
        return sb.toString();
    }

    static String getClassNameForGenericType(SignatureAttribute.ClassType type) {
        if (type.getDeclaringClass() == null) {
            return type.getName();
        }
        StringBuilder sb = new StringBuilder(type.getName());
        while (type.getDeclaringClass() != null) {
            sb.insert(0, type.getDeclaringClass().getName() + "$");
            type = type.getDeclaringClass();
        }
        return sb.toString();
    }

    private static void appendTypeGenericInfo(SignatureAttribute.ObjectType type, JavassistTypeVariableSpy spy, StringBuilder sb, Set<String> doneVars) {
        if (type instanceof SignatureAttribute.ClassType) {
            SignatureAttribute.ClassType ctype = (SignatureAttribute.ClassType)type;
            sb.append(JavassistHelper.getClassNameForGenericType(ctype));
            SignatureAttribute.TypeArgument[] arguments = ctype.getTypeArguments();
            if (arguments != null && arguments.length > 0) {
                StringBuilder params = new StringBuilder();
                params.append("<");
                for (int i = 0; i < arguments.length; ++i) {
                    if (i > 0) {
                        params.append(", ");
                    }
                    if (arguments[i].getType() == null) {
                        params.append(Object.class.getName());
                        continue;
                    }
                    JavassistHelper.appendTypeGenericInfo(arguments[i].getType(), spy, params, doneVars);
                }
                if (params.length() > 1) {
                    params.append(">");
                    sb.append(params.toString());
                }
            }
        } else if (type instanceof SignatureAttribute.TypeVariable) {
            SignatureAttribute.TypeVariable tv = (SignatureAttribute.TypeVariable)type;
            SignatureAttribute.Type real = spy.getTypeBound(tv);
            if (!(real instanceof SignatureAttribute.ObjectType)) {
                throw new IllegalStateException("Type is not an instance of ObjectType " + real);
            }
            if (doneVars == null) {
                doneVars = new HashSet<String>();
            }
            tv.getName();
            if (!doneVars.contains(tv.getName())) {
                doneVars.add(tv.getName());
                JavassistHelper.appendTypeGenericInfo((SignatureAttribute.ObjectType)real, spy, sb, doneVars);
            }
        } else if (type instanceof SignatureAttribute.ArrayType) {
            SignatureAttribute.ArrayType array = (SignatureAttribute.ArrayType)type;
            if (array.getComponentType() instanceof SignatureAttribute.BaseType) {
                sb.append(array.getComponentType());
            } else {
                JavassistHelper.appendTypeGenericInfo((SignatureAttribute.ObjectType)array.getComponentType(), spy, sb, doneVars);
            }
            for (int i = 0; i < array.getDimension(); ++i) {
                sb.append("[]");
            }
        } else {
            throw new IllegalArgumentException("Unhandled type " + type);
        }
    }

    private static SignatureAttribute.ClassType determineType(Stack<ClassInfo> hierarchy, int parameter) {
        TypeDecider decider = new TypeDecider();
        decider.determineType(hierarchy, parameter);
        return decider.classType;
    }

    private static int determineInfoIndex(TypeInfo[] actualTypeArguments, Stack<ClassInfo> hierarchy, int parameter) {
        TypeDecider decider = new TypeDecider();
        decider.determineType(hierarchy, parameter);
        return decider.lastIndex;
    }

    public static SignatureAttribute.ClassSignature getClassSignature(CtClass clazz) {
        if (clazz == null) {
            throw new IllegalArgumentException("Null clazz");
        }
        if (clazz.isArray() || clazz.isPrimitive()) {
            return null;
        }
        SignatureAttribute signature = (SignatureAttribute)clazz.getClassFile2().getAttribute("Signature");
        if (signature == null) {
            return null;
        }
        String sig = signature.getSignature();
        try {
            return SignatureAttribute.toClassSignature((String)sig);
        }
        catch (BadBytecode e) {
            throw new IllegalStateException(e);
        }
    }

    public static TypeInfo[] createParameterTypes(SignatureAttribute.MethodSignature sig, JavassistClassInfo typeInfo) {
        SignatureAttribute.Type[] types = sig.getParameterTypes();
        TypeInfo[] parameterTypes = new TypeInfo[types.length];
        for (int i = 0; i < types.length; ++i) {
            parameterTypes[i] = typeInfo.getFactory().getTypeInfo(typeInfo.getClassLoaderInternal(), types[i], JavassistTypeVariableSpy.createForBehavior(typeInfo.getClassSignature(), sig));
        }
        return parameterTypes;
    }

    public static SignatureAttribute.MethodSignature getMethodSignature(CtBehavior behaviour) {
        if (behaviour == null) {
            throw new IllegalArgumentException("Null method/constructor");
        }
        SignatureAttribute signature = (SignatureAttribute)behaviour.getMethodInfo2().getAttribute("Signature");
        if (signature == null) {
            return null;
        }
        String sig = signature.getSignature();
        try {
            return SignatureAttribute.toMethodSignature((String)sig);
        }
        catch (BadBytecode e) {
            throw new IllegalStateException(e);
        }
    }

    public static SignatureAttribute.ObjectType getFieldSignature(CtField field) {
        if (field == null) {
            throw new IllegalArgumentException("Null method/constructor");
        }
        SignatureAttribute signature = (SignatureAttribute)field.getFieldInfo2().getAttribute("Signature");
        if (signature == null) {
            return null;
        }
        String sig = signature.getSignature();
        try {
            return SignatureAttribute.toFieldSignature((String)sig);
        }
        catch (BadBytecode e) {
            throw new IllegalStateException(e);
        }
    }

    public static boolean determineHierarchy(Stack<ClassInfo> hierarchy, ClassInfo current, ClassInfo search) throws NotFoundException {
        ClassInfo superClass;
        boolean result;
        if (current == null) {
            throw new IllegalArgumentException("Null current");
        }
        if (search == null) {
            throw new IllegalArgumentException("Null search");
        }
        if (hierarchy != null) {
            hierarchy.push(current);
        }
        if (current == null) {
            return false;
        }
        if (current.equals(search)) {
            return true;
        }
        InterfaceInfo[] interfaces = current.getGenericInterfaces();
        if (search.isInterface() && interfaces != null) {
            for (int i = 0; i < interfaces.length; ++i) {
                result = JavassistHelper.determineHierarchy(hierarchy, interfaces[i], search);
                if (result) {
                    return true;
                }
                if (hierarchy == null) continue;
                hierarchy.pop();
            }
        }
        if ((superClass = current.getGenericSuperclass()) == null) {
            return false;
        }
        result = JavassistHelper.determineHierarchy(hierarchy, superClass, search);
        if (result) {
            return true;
        }
        if (hierarchy != null) {
            hierarchy.pop();
        }
        return false;
    }

    private static SignatureAttribute.TypeArgument findSuperClassOrInterfaceArguments(ClassInfo parent, SignatureAttribute.ClassSignature classSig, int index) {
        if (parent == null) {
            throw new IllegalArgumentException();
        }
        SignatureAttribute.TypeArgument[] arguments = null;
        if (parent.isInterface()) {
            Object[] types = classSig.getInterfaces();
            for (int i = 0; i < types.length; ++i) {
                if (!types[i].getName().equals(parent.getName())) continue;
                arguments = types[i].getTypeArguments();
                break;
            }
            if (arguments == null) {
                throw new IllegalStateException("Could not find " + parent.getName() + " in " + Arrays.toString(types));
            }
        } else {
            arguments = classSig.getSuperClass().getTypeArguments();
        }
        if (arguments.length <= index) {
            throw new IllegalArgumentException("Argument " + index + " requested, but only " + arguments.length + " exist");
        }
        return arguments[index];
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class TypeDecider {
        int lastIndex;
        ClassInfo last = null;
        SignatureAttribute.ClassType classType;

        private TypeDecider() {
        }

        private SignatureAttribute.ClassSignature getClassSignature(ClassInfo info) {
            if (info instanceof JavassistClassInfo) {
                return ((JavassistClassInfo)info).getClassSignature();
            }
            return null;
        }

        private void determineType(Stack<ClassInfo> hierarchy, int parameter) {
            ClassInfo clazz = null;
            SignatureAttribute.TypeParameter targetType = null;
            this.lastIndex = parameter;
            block0: while (!hierarchy.empty()) {
                this.last = clazz;
                clazz = hierarchy.pop();
                SignatureAttribute.ClassSignature classSig = this.getClassSignature(clazz);
                if (classSig == null) break;
                SignatureAttribute.TypeParameter[] typeParameters = classSig.getParameters();
                if (this.last == null) {
                    if (typeParameters.length <= parameter) {
                        throw new IllegalArgumentException("Parameter " + parameter + " requested, but only " + typeParameters.length + " exist.");
                    }
                    targetType = typeParameters[parameter];
                    continue;
                }
                SignatureAttribute.TypeArgument argument = JavassistHelper.findSuperClassOrInterfaceArguments(this.last, classSig, this.lastIndex);
                SignatureAttribute.ObjectType type = argument.getType();
                if (type == null) continue;
                if (type instanceof SignatureAttribute.ClassType) {
                    this.classType = (SignatureAttribute.ClassType)type;
                    return;
                }
                String name = null;
                if (type instanceof SignatureAttribute.TypeVariable) {
                    name = ((SignatureAttribute.TypeVariable)type).getName();
                }
                for (int i = 0; i < typeParameters.length; ++i) {
                    if (!typeParameters[i].getName().equals(name)) continue;
                    this.lastIndex = i;
                    targetType = typeParameters[i];
                    continue block0;
                }
            }
            if (targetType != null) {
                this.classType = (SignatureAttribute.ClassType)targetType.getClassBound();
                return;
            }
        }
    }
}

