/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist;

import java.util.Arrays;
import javassist.CtBehavior;
import javassist.CtClass;
import javassist.CtMethod;
import javassist.NotFoundException;
import javassist.bytecode.SignatureAttribute;
import org.jboss.reflect.plugins.AnnotationHelper;
import org.jboss.reflect.plugins.MethodInfoInternal;
import org.jboss.reflect.plugins.javassist.JavassistAccessController;
import org.jboss.reflect.plugins.javassist.JavassistAnnotatedParameterInfo;
import org.jboss.reflect.plugins.javassist.JavassistMethod;
import org.jboss.reflect.plugins.javassist.JavassistReflectionFactory;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfo;
import org.jboss.reflect.plugins.javassist.JavassistTypeInfoFactoryImpl;
import org.jboss.reflect.plugins.javassist.JavassistTypeVariableSpy;
import org.jboss.reflect.plugins.javassist.SignatureKey;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.MethodInfo;
import org.jboss.reflect.spi.MutableMethodInfo;
import org.jboss.reflect.spi.MutableMethodInfoCommand;
import org.jboss.reflect.spi.TypeInfo;
import org.jboss.util.JBossStringBuilder;

public class JavassistMethodInfo
extends JavassistAnnotatedParameterInfo
implements MutableMethodInfo,
MethodInfoInternal {
    private static final long serialVersionUID = 101183748227690112L;
    private volatile transient JavassistMethod method;
    private volatile transient TypeInfo returnType;
    private volatile transient String name;

    public JavassistMethodInfo(SignatureKey signatureKey, AnnotationHelper annotationHelper, JavassistTypeInfo typeInfo, CtMethod ctMethod) {
        super(signatureKey, annotationHelper, typeInfo, (CtBehavior)ctMethod);
    }

    public String getName() {
        if (this.name == null) {
            this.name = this.getCtMethod().getName();
        }
        return this.name;
    }

    public TypeInfo getReturnType() {
        if (this.returnType != null) {
            return this.returnType;
        }
        try {
            CtMethod ctMethod = (CtMethod)this.ctBehavior;
            SignatureAttribute.MethodSignature sig = this.getMethodSignature();
            if (sig != null && !(sig.getReturnType() instanceof SignatureAttribute.BaseType)) {
                return this.typeInfo.getFactory().getTypeInfo(this.typeInfo.getClassLoaderInternal(), sig.getReturnType(), JavassistTypeVariableSpy.createForBehavior(this.getDeclaringClass().getClassSignature(), sig));
            }
            CtClass clazz = ctMethod.getReturnType();
            this.returnType = this.typeInfo.getFactory().getTypeInfo(clazz);
        }
        catch (NotFoundException e) {
            throw JavassistTypeInfoFactoryImpl.raiseClassNotFound("for return type of method " + this.getName(), e);
        }
        return this.returnType;
    }

    public Object invoke(Object target, Object[] args) throws Throwable {
        if (this.method == null) {
            JavassistMethod m = JavassistReflectionFactory.INSTANCE.createMethod(this);
            if (this.method == null) {
                this.method = m;
            }
        }
        JavassistAccessController.checkAccess(this);
        return this.method.invoke(target, args);
    }

    protected int getHashCode() {
        return this.getName().hashCode();
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof MethodInfo)) {
            return false;
        }
        MethodInfo other = (MethodInfo)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (other instanceof JavassistMethodInfo) {
            return this.getSignatureKey().equals(((JavassistMethodInfo)other).getSignatureKey());
        }
        return Arrays.equals(this.getParameterTypes(), other.getParameterTypes());
    }

    public void toShortString(JBossStringBuilder buffer) {
        buffer.append(this.getName());
    }

    protected void toString(JBossStringBuilder buffer) {
        buffer.append("name=").append(this.getName());
        super.toString(buffer);
    }

    public void executeCommand(MutableMethodInfoCommand mmc) {
    }

    public CtMethod getCtMethod() {
        return (CtMethod)this.ctBehavior;
    }

    public void setName(String name) {
        ((CtMethod)this.ctBehavior).setName(name);
        this.typeInfo.clearMethodCache();
    }

    public void setReturnType(String returnType) {
        throw new RuntimeException("Method not supported by Javassist");
    }

    public void setReturnType(ClassInfo returnType) {
        throw new RuntimeException("Method not supported by Javassist");
    }

    public int getNumberParameters() {
        return this.getSignatureKey().getParams().length;
    }
}

