/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.reflect.plugins.javassist.defaultmember;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.jboss.reflect.plugins.introspection.ReflectClassInfoImpl;
import org.jboss.reflect.plugins.introspection.ReflectionUtils;
import org.jboss.reflect.plugins.javassist.JavassistMethod;

class DefaultJavassistMethod
extends ReflectClassInfoImpl
implements JavassistMethod {
    private static final long serialVersionUID = 1L;
    private final Method method;

    DefaultJavassistMethod(Method method) {
        this.method = method;
        if (method != null && !Modifier.isPublic(method.getModifiers()) || !Modifier.isPublic(method.getDeclaringClass().getModifiers())) {
            this.setAccessible();
        }
    }

    public Object invoke(Object target, Object[] args) throws Throwable {
        return ReflectionUtils.invoke(this.method, target, args);
    }

    protected boolean isDeclaringClassPublic() {
        Class<?> owner = this.method.getDeclaringClass();
        return Modifier.isPublic(owner.getModifiers());
    }

    private void setAccessible() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            this.method.setAccessible(true);
        } else {
            AccessController.doPrivileged(new SetAccessible());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class SetAccessible
    implements PrivilegedAction<Object> {
        private SetAccessible() {
        }

        @Override
        public Object run() {
            DefaultJavassistMethod.this.method.setAccessible(true);
            return null;
        }
    }
}

