/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.core.binding;

import java.util.HashMap;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.rpc.encoding.Serializer;
import javax.xml.transform.Result;
import org.jboss.util.NotImplementedException;
import org.jboss.ws.core.binding.BindingException;
import org.jboss.ws.core.binding.SerializationContext;
import org.jboss.ws.core.soap.SOAPContentElement;
import org.jboss.wsf.common.Normalizer;
import org.jboss.xb.binding.NamespaceRegistry;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public abstract class SerializerSupport
implements Serializer {
    public Result serialize(SOAPContentElement soapElement, SerializationContext serContext) throws BindingException {
        QName xmlName = soapElement.getElementQName();
        QName xmlType = soapElement.getXmlType();
        NamedNodeMap attributes = soapElement.getAttributes();
        Object objectValue = soapElement.getObjectValue();
        return this.serialize(xmlName, xmlType, objectValue, serContext, attributes);
    }

    public abstract Result serialize(QName var1, QName var2, Object var3, SerializationContext var4, NamedNodeMap var5) throws BindingException;

    protected String wrapValueStr(QName xmlName, String valueStr, NamespaceRegistry nsRegistry, Set<String> nsExtras, NamedNodeMap attributes, boolean normalize) {
        String xmlFragment;
        String elName;
        String xmlNameURI = xmlName.getNamespaceURI();
        String localPart = xmlName.getLocalPart();
        HashMap<String, String> namespaces = new HashMap<String, String>();
        StringBuilder nsAttr = new StringBuilder("");
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                Node attr = attributes.item(i);
                String attrName = attr.getNodeName();
                String attrValue = attr.getNodeValue();
                nsAttr.append(" " + attrName + "='" + attrValue + "'");
                if (!attrName.startsWith("xmlns:")) continue;
                String prefix = attrName.substring(6);
                namespaces.put(attrValue, prefix);
            }
        }
        if (xmlNameURI.length() > 0) {
            xmlName = nsRegistry.registerQName(xmlName);
            String prefix = xmlName.getPrefix();
            elName = prefix + ":" + localPart;
            if (namespaces.get(xmlNameURI) == null || !prefix.equals(namespaces.get(xmlNameURI))) {
                nsAttr.append(" xmlns:" + prefix + "='" + xmlNameURI + "'");
                namespaces.put(xmlNameURI, prefix);
            }
        } else {
            elName = localPart;
        }
        if (nsExtras != null) {
            for (String nsURI : nsExtras) {
                String prefix = nsRegistry.getPrefix(nsURI);
                if (namespaces.get(nsURI) != null && prefix.equals(namespaces.get(nsURI))) continue;
                nsAttr.append(" xmlns:" + prefix + "='" + nsURI + "'");
                namespaces.put(nsURI, prefix);
            }
        }
        if (valueStr == null) {
            String xsins = "";
            if (namespaces.get("http://www.w3.org/2001/XMLSchema-instance") == null || !"xsi".equals(namespaces.get(xmlNameURI))) {
                xsins = " xmlns:xsi='http://www.w3.org/2001/XMLSchema-instance'";
                namespaces.put("http://www.w3.org/2001/XMLSchema-instance", "xsi");
            }
            xmlFragment = "<" + elName + nsAttr + " " + "xsi" + ":nil='1'" + xsins + "/>";
        } else {
            if (normalize) {
                valueStr = Normalizer.normalize((String)valueStr);
            }
            xmlFragment = "<" + elName + nsAttr + ">" + valueStr + "</" + elName + ">";
        }
        return xmlFragment;
    }

    public String getMechanismType() {
        throw new NotImplementedException();
    }
}

