/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.SOAPElement;
import org.apache.xerces.xs.XSComplexTypeDefinition;
import org.apache.xerces.xs.XSElementDeclaration;
import org.apache.xerces.xs.XSModelGroup;
import org.apache.xerces.xs.XSObjectList;
import org.apache.xerces.xs.XSParticle;
import org.apache.xerces.xs.XSSimpleTypeDefinition;
import org.apache.xerces.xs.XSTerm;
import org.apache.xerces.xs.XSTypeDefinition;
import org.jboss.ws.WSException;
import org.jboss.ws.core.jaxrpc.LiteralTypeMapping;
import org.jboss.ws.metadata.wsdl.WSDLBindingOperation;
import org.jboss.ws.metadata.wsdl.WSDLDefinitions;
import org.jboss.ws.metadata.wsdl.WSDLException;
import org.jboss.ws.metadata.wsdl.WSDLInterface;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceFault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperation;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationInput;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutfault;
import org.jboss.ws.metadata.wsdl.WSDLInterfaceOperationOutput;
import org.jboss.ws.metadata.wsdl.WSDLRPCPart;
import org.jboss.ws.metadata.wsdl.WSDLSOAPHeader;
import org.jboss.ws.metadata.wsdl.WSDLTypes;
import org.jboss.ws.metadata.wsdl.WSDLUtils;
import org.jboss.ws.metadata.wsdl.xmlschema.JBossXSModel;
import org.jboss.ws.metadata.wsdl.xsd.SchemaUtils;
import org.jboss.ws.tools.HeaderUtil;
import org.jboss.ws.tools.HolderWriter;
import org.jboss.ws.tools.JavaKeywords;
import org.jboss.ws.tools.NamespacePackageMapping;
import org.jboss.ws.tools.RPCSignature;
import org.jboss.ws.tools.ToolsUtils;
import org.jboss.ws.tools.XSDTypeToJava;
import org.jboss.ws.tools.helpers.ReturnTypeUnwrapper;
import org.jboss.ws.tools.interfaces.WSDLToJavaIntf;
import org.jboss.ws.tools.wsdl.WSDLDefinitionsFactory;
import org.jboss.wsf.common.JavaUtils;
import org.w3c.dom.Element;

public class WSDLToJava
implements WSDLToJavaIntf {
    private String newline = "\n";
    protected LiteralTypeMapping typeMapping = null;
    protected WSDLDefinitions wsdl = null;
    protected WSDLUtils utils = WSDLUtils.getInstance();
    protected boolean annotate = false;
    protected Map<String, String> namespacePackageMap = null;
    protected boolean generateSerializableTypes = false;
    protected HolderWriter holderWriter = new HolderWriter();
    private String seiPkgName = "";
    private String directoryToGenerate = "";
    private String style;
    private String parameterStyle;

    @Override
    public WSDLDefinitions convertWSDL2Java(URL wsdlfileurl) throws WSDLException {
        this.checkTypeMapping();
        WSDLDefinitionsFactory wsdlFactory = WSDLDefinitionsFactory.newInstance();
        this.wsdl = wsdlFactory.parse(wsdlfileurl);
        return this.wsdl;
    }

    @Override
    public boolean getFeature(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Illegal null argument:name");
        }
        if (name.equalsIgnoreCase("http://www.jboss.org/wstools/Use_Annotations")) {
            return this.annotate;
        }
        throw new WSException("Feature:" + name + " not recognized");
    }

    @Override
    public void setFeature(String name, boolean value) {
        if (name == null) {
            throw new IllegalArgumentException("Illegal null argument:name");
        }
        if (name.equalsIgnoreCase("http://www.jboss.org/wstools/Use_Annotations")) {
            this.annotate = value;
        }
    }

    @Override
    public void generateSEI(URL wsdlFile, File dir, boolean annotate) throws IOException {
        this.checkTypeMapping();
        WSDLDefinitions wsdl = this.convertWSDL2Java(wsdlFile);
        this.annotate = annotate;
        this.directoryToGenerate = dir.getAbsolutePath();
        this.generateSEI(wsdl, dir);
    }

    @Override
    public void generateSEI(WSDLDefinitions wsdl, File dir) throws IOException {
        String packageName;
        this.checkTypeMapping();
        this.directoryToGenerate = dir.getAbsolutePath();
        this.wsdl = wsdl;
        this.style = this.utils.getWSDLStyle(wsdl);
        String targetNS = wsdl.getTargetNamespace();
        String string = packageName = this.namespacePackageMap != null ? this.namespacePackageMap.get(targetNS) : null;
        if (packageName == null || packageName.length() == 0) {
            packageName = NamespacePackageMapping.getJavaPackageName(targetNS);
        }
        this.seiPkgName = packageName;
        File dirloc = this.utils.createPackage(dir.getAbsolutePath(), packageName);
        this.createSEI(dirloc, wsdl);
    }

    public Map<String, String> getNamespacePackageMap() {
        return this.namespacePackageMap;
    }

    @Override
    public void setNamespacePackageMap(Map<String, String> map) {
        Set<String> keys = map.keySet();
        Iterator<String> iter = keys.iterator();
        while (iter != null && iter.hasNext()) {
            if (this.namespacePackageMap == null) {
                this.namespacePackageMap = new HashMap<String, String>();
            }
            String pkg = iter.next();
            this.namespacePackageMap.put(pkg, map.get(pkg));
        }
    }

    public boolean isGenerateSerializableTypes() {
        return this.generateSerializableTypes;
    }

    public void setGenerateSerializableTypes(boolean generateSerializableTypes) {
        this.generateSerializableTypes = generateSerializableTypes;
    }

    @Override
    public void setTypeMapping(LiteralTypeMapping tm) {
        this.typeMapping = tm;
    }

    private boolean isDocument() {
        return "Document/Literal".equals(this.style);
    }

    private boolean isWrapped() {
        return "wrapped".equals(this.parameterStyle) && "Document/Literal".equals(this.style);
    }

    private void appendMethods(WSDLInterface intf, StringBuilder buf) throws IOException {
        buf.append(this.newline);
        String itfname = intf.getName().getLocalPart();
        WSDLInterfaceOperation[] ops = intf.getOperations();
        if (ops == null || ops.length == 0) {
            throw new IllegalArgumentException("Interface " + itfname + " doesn't have operations");
        }
        int len = ops != null ? ops.length : 0;
        for (int i = 0; i < len; ++i) {
            WSDLInterfaceOperation op = ops[i];
            WSDLBindingOperation bindingOperation = HeaderUtil.getWSDLBindingOperation(this.wsdl, op);
            String returnType = null;
            StringBuilder paramBuffer = new StringBuilder();
            WSDLInterfaceOperationInput input = WSDLUtils.getWsdl11Input(op);
            WSDLInterfaceOperationOutput output = WSDLUtils.getWsdl11Output(op);
            returnType = this.isDocument() ? this.appendDocParameters(paramBuffer, input, output, bindingOperation) : this.appendRpcParameters(paramBuffer, op, output, bindingOperation);
            if (returnType == null) {
                returnType = "void";
            }
            buf.append("  public " + returnType + "  ");
            buf.append(ToolsUtils.firstLetterLowerCase(op.getName().getLocalPart()));
            buf.append("(").append((CharSequence)paramBuffer);
            buf.append(") throws ");
            WSDLInterfaceOperationOutfault[] outfaults = op.getOutfaults();
            for (int k = 0; k < outfaults.length; ++k) {
                Class cl;
                WSDLInterfaceOperationOutfault fault = outfaults[k];
                QName faultName = fault.getRef();
                WSDLInterfaceFault intfFault = fault.getWsdlInterfaceOperation().getWsdlInterface().getFault(faultName);
                JBossXSModel xsmodel = WSDLUtils.getSchemaModel(this.wsdl.getWsdlTypes());
                QName faultXMLName = intfFault.getElement();
                QName faultXMLType = intfFault.getXmlType();
                XSElementDeclaration xe = xsmodel.getElementDeclaration(faultXMLName.getLocalPart(), faultXMLName.getNamespaceURI());
                XSTypeDefinition xt = xe.getTypeDefinition();
                if (!xt.getAnonymous()) {
                    xt = xsmodel.getTypeDefinition(xt.getName(), xt.getNamespace());
                }
                if (xt instanceof XSComplexTypeDefinition) {
                    this.generateJavaSource((XSComplexTypeDefinition)xt, xsmodel, faultXMLName.getLocalPart(), true);
                }
                if ((cl = this.getJavaType(faultXMLType, false)) == null) {
                    String faultTypeName = !xt.getAnonymous() ? faultXMLType.getLocalPart() : faultXMLName.getLocalPart();
                    String packageName = this.getPackageName(xt.getNamespace());
                    buf.append(packageName + "." + JavaUtils.capitalize((String)faultTypeName));
                } else {
                    buf.append(cl.getName());
                }
                buf.append(",");
            }
            buf.append(" java.rmi.RemoteException");
            buf.append(";");
            buf.append(this.newline);
        }
    }

    private String appendRpcParameters(StringBuilder paramBuffer, WSDLInterfaceOperation op, WSDLInterfaceOperationOutput output, WSDLBindingOperation bindingOperation) throws IOException {
        String returnType = null;
        boolean first = true;
        RPCSignature signature = new RPCSignature(op);
        for (WSDLRPCPart part : signature.parameters()) {
            if (first) {
                first = false;
            } else {
                paramBuffer.append(", ");
            }
            QName xmlName = new QName(part.getName());
            QName xmlType = part.getType();
            JBossXSModel xsmodel = WSDLUtils.getSchemaModel(this.wsdl.getWsdlTypes());
            XSTypeDefinition xt = xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
            boolean holder = output != null && output.getChildPart(part.getName()) != null;
            this.generateParameter(paramBuffer, xmlName.getLocalPart(), xmlType, xsmodel, xt, false, true, holder);
            paramBuffer.append(" ").append(this.getMethodParam(xmlName.getLocalPart()));
        }
        if (signature.returnParameter() != null) {
            QName xmlName = new QName(signature.returnParameter().getName());
            QName xmlType = signature.returnParameter().getType();
            JBossXSModel xsmodel = WSDLUtils.getSchemaModel(this.wsdl.getWsdlTypes());
            XSTypeDefinition xt = xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
            returnType = this.getReturnType(xmlName, xmlType, xt);
        }
        if (bindingOperation != null) {
            this.appendHeaderParameters(paramBuffer, bindingOperation);
        }
        return returnType;
    }

    private String appendDocParameters(StringBuilder paramBuffer, WSDLInterfaceOperationInput input, WSDLInterfaceOperationOutput output, WSDLBindingOperation bindingOperation) throws IOException {
        QName xmlName;
        String returnType = null;
        boolean holder = false;
        if (input != null && input.getElement() != null) {
            xmlName = input.getElement();
            holder = output != null && xmlName.equals(output.getElement());
            this.appendParameters(paramBuffer, input, output, xmlName.getLocalPart());
        }
        if (!holder && output != null && output.getElement() != null) {
            xmlName = output.getElement();
            QName xmlType = output.getXMLType();
            JBossXSModel xsmodel = WSDLUtils.getSchemaModel(this.wsdl.getWsdlTypes());
            XSTypeDefinition xt = xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
            returnType = this.getReturnType(xmlName, xmlType, xt);
        }
        if (bindingOperation != null) {
            this.appendHeaderParameters(paramBuffer, bindingOperation);
        }
        return returnType;
    }

    private void appendHeaderParameters(StringBuilder buf, WSDLBindingOperation bindingOperation) throws IOException {
        WSDLSOAPHeader[] inputHeaders = HeaderUtil.getSignatureHeaders(bindingOperation.getInputs());
        WSDLSOAPHeader[] outputHeaders = HeaderUtil.getSignatureHeaders(bindingOperation.getOutputs());
        for (WSDLSOAPHeader currentInput : inputHeaders) {
            boolean holder = HeaderUtil.containsMatchingPart(outputHeaders, currentInput);
            this.appendHeaderParameter(buf, currentInput, holder);
        }
        for (WSDLSOAPHeader currentOutput : outputHeaders) {
            boolean input = HeaderUtil.containsMatchingPart(inputHeaders, currentOutput);
            if (input) continue;
            this.appendHeaderParameter(buf, currentOutput, true);
        }
    }

    private void appendHeaderParameter(StringBuilder buf, WSDLSOAPHeader header, boolean holder) throws IOException {
        QName elementName = header.getElement();
        JBossXSModel xsmodel = WSDLUtils.getSchemaModel(this.wsdl.getWsdlTypes());
        XSElementDeclaration xe = xsmodel.getElementDeclaration(elementName.getLocalPart(), elementName.getNamespaceURI());
        XSTypeDefinition xt = xe.getTypeDefinition();
        WSDLTypes wsdlTypes = this.wsdl.getWsdlTypes();
        QName xmlType = wsdlTypes.getXMLType(header.getElement());
        xt = xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
        if (buf.length() > 0) {
            buf.append(", ");
        }
        this.generateParameter(buf, xe.getName(), xmlType, xsmodel, xt, false, true, holder);
        buf.append(" ").append(header.getPartName());
    }

    private void appendParameters(StringBuilder buf, WSDLInterfaceOperationInput in, WSDLInterfaceOperationOutput output, String containingElement) throws IOException {
        QName xmlType = in.getXMLType();
        JBossXSModel xsmodel = WSDLUtils.getSchemaModel(this.wsdl.getWsdlTypes());
        XSTypeDefinition xt = xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
        boolean wrapped = this.isWrapped();
        if (wrapped) {
            int inputs = in.getWsdlOperation().getInputs().length;
            if (inputs > 1) {
                throw new WSException("[JAX-RPC - 2.3.1.2] Can not unwrap parameters for operation with mutliple inputs. inputs=" + inputs);
            }
            String operationName = in.getWsdlOperation().getName().getLocalPart();
            String elementName = in.getElement().getLocalPart();
            if (!elementName.equals(operationName)) {
                throw new WSException("[JAX-RPC - 2.3.1.2] Unable to unwrap parameters, wrapper element name must match operation name. operationName=" + operationName + " elementName=" + elementName);
            }
            wrapped = this.unwrapElementParameters(buf, containingElement, xt);
        }
        if (!wrapped) {
            QName xmlName = in.getElement();
            boolean holder = output != null && xmlName.equals(output.getElement());
            this.generateParameter(buf, containingElement, xmlType, xsmodel, xt, false, true, holder);
            buf.append(" ").append(this.getMethodParam(containingElement));
        }
    }

    private boolean unwrapElementParameters(StringBuilder buf, String containingElement, XSTypeDefinition xt) throws IOException {
        boolean hasAttributes;
        if (!(xt instanceof XSComplexTypeDefinition)) {
            return false;
        }
        StringBuilder tempBuf = new StringBuilder();
        XSComplexTypeDefinition wrapper = (XSComplexTypeDefinition)xt;
        boolean bl = hasAttributes = wrapper.getAttributeUses().getLength() > 0;
        if (hasAttributes) {
            throw new WSException("[JAX-RPC 2.3.1.2] Can not unwrap, complex type contains attributes.");
        }
        boolean unwrappedElement = false;
        XSParticle particle = wrapper.getParticle();
        if (particle == null) {
            unwrappedElement = true;
        } else {
            XSTerm term = particle.getTerm();
            if (term instanceof XSModelGroup) {
                unwrappedElement = this.unwrapGroup(tempBuf, containingElement, (XSModelGroup)term);
            }
        }
        if (unwrappedElement) {
            buf.append((CharSequence)tempBuf);
            this.generateJavaSource(wrapper, WSDLUtils.getSchemaModel(this.wsdl.getWsdlTypes()), containingElement);
            return true;
        }
        return false;
    }

    public boolean unwrapGroup(StringBuilder buf, String containingElement, XSModelGroup group) throws IOException {
        if (group.getCompositor() != 1) {
            return false;
        }
        XSObjectList particles = group.getParticles();
        for (int i = 0; i < particles.getLength(); ++i) {
            XSParticle particle = (XSParticle)particles.item(i);
            XSTerm term = particle.getTerm();
            if (term instanceof XSModelGroup) {
                if (this.unwrapGroup(buf, containingElement, (XSModelGroup)term)) continue;
                return false;
            }
            if (!(term instanceof XSElementDeclaration)) continue;
            if (buf.length() > 0) {
                buf.append(", ");
            }
            XSElementDeclaration element = (XSElementDeclaration)term;
            XSTypeDefinition type = element.getTypeDefinition();
            String tempContainingElement = containingElement + ToolsUtils.firstLetterUpperCase(element.getName());
            QName xmlType = null;
            if (!type.getAnonymous()) {
                xmlType = new QName(type.getNamespace(), type.getName());
            }
            JBossXSModel xsmodel = WSDLUtils.getSchemaModel(this.wsdl.getWsdlTypes());
            boolean array = particle.getMaxOccursUnbounded() || particle.getMaxOccurs() > 1;
            boolean primitive = !element.getNillable() && (particle.getMinOccurs() != 0 || particle.getMaxOccurs() != 1);
            this.generateParameter(buf, tempContainingElement, xmlType, xsmodel, type, array, primitive, false);
            String paramName = type.getAnonymous() ? containingElement : element.getName();
            buf.append(" ").append(this.getMethodParam(paramName));
        }
        return true;
    }

    private void generateParameter(StringBuilder buf, String containingElement, QName xmlType, JBossXSModel xsmodel, XSTypeDefinition xt, boolean array, boolean primitive, boolean holder) throws IOException {
        String arraySuffix;
        WrappedArray wrappedArray = new WrappedArray(xt);
        String string = arraySuffix = array ? "[]" : "";
        if (wrappedArray.unwrap()) {
            xt = wrappedArray.xt;
            xmlType = wrappedArray.xmlType;
            primitive = !wrappedArray.nillable;
            arraySuffix = wrappedArray.suffix;
        }
        if (xt instanceof XSSimpleTypeDefinition) {
            xmlType = SchemaUtils.handleSimpleType((XSSimpleTypeDefinition)xt);
        }
        Class cl = null;
        if (xmlType != null) {
            cl = this.getJavaType(xmlType, primitive);
        }
        if (cl != null) {
            if (holder) {
                cl = this.utils.getHolder(cl);
            }
            buf.append(JavaUtils.getSourceName((Class)cl) + arraySuffix);
        } else {
            String className = xt == null || xt.getAnonymous() ? containingElement : xmlType.getLocalPart();
            if (className.charAt(0) == '>') {
                className = className.substring(1);
            }
            className = ToolsUtils.convertInvalidCharacters(className);
            className = this.utils.firstLetterUpperCase(className);
            String packageName = this.getPackageName(xt.getNamespace());
            className = packageName + "." + className + arraySuffix;
            if (holder) {
                className = this.holderWriter.getOrCreateHolder(className, this.getLocationForJavaGeneration(packageName));
            }
            buf.append(className);
            if (xt instanceof XSComplexTypeDefinition) {
                this.generateJavaSource((XSComplexTypeDefinition)xt, xsmodel, containingElement);
            }
        }
    }

    private void createSEIFile(WSDLInterface intf, File loc) throws IOException {
        String seiName = this.getServiceEndpointInterfaceName(intf);
        StringBuilder buf = new StringBuilder();
        this.utils.writeJbossHeader(buf);
        buf.append("package " + this.seiPkgName + ";" + this.newline);
        buf.append("public interface  " + seiName + " extends java.rmi.Remote" + this.newline + "{" + this.newline);
        this.appendMethods(intf, buf);
        buf.append("}" + this.newline);
        File sei = this.utils.createPhysicalFile(loc, seiName);
        FileWriter writer = new FileWriter(sei);
        writer.write(buf.toString());
        writer.flush();
        writer.close();
    }

    public String getServiceEndpointInterfaceName(WSDLInterface wsdlInterface) {
        String seiName = this.utils.chopPortType(wsdlInterface.getName().getLocalPart());
        if (this.wsdl.getService(seiName) != null) {
            seiName = seiName + "_PortType";
        }
        seiName = JavaUtils.capitalize((String)seiName);
        seiName = ToolsUtils.convertInvalidCharacters(seiName);
        return seiName;
    }

    private void createSEI(File loc, WSDLDefinitions wsdl) throws IOException {
        WSDLInterface[] intarr = wsdl.getInterfaces();
        if (intarr == null || intarr.length == 0) {
            throw new IllegalArgumentException("Interfaces cannot be zero");
        }
        for (WSDLInterface intf : intarr) {
            this.createSEIFile(intf, loc);
        }
    }

    private String getReturnType(QName xmlName, QName xmlType, XSTypeDefinition xt) throws IOException {
        WrappedArray wrappedArray;
        String containingElement = xmlName.getLocalPart();
        String arraySuffix = "";
        boolean primitive = true;
        JBossXSModel xsmodel = WSDLUtils.getSchemaModel(this.wsdl.getWsdlTypes());
        xt = xsmodel.getTypeDefinition(xmlType.getLocalPart(), xmlType.getNamespaceURI());
        ReturnTypeUnwrapper unwrapper = new ReturnTypeUnwrapper(xmlType, xsmodel, this.isWrapped());
        if (unwrapper.unwrap()) {
            if (xt instanceof XSComplexTypeDefinition) {
                this.generateJavaSource((XSComplexTypeDefinition)xt, xsmodel, containingElement);
            }
            if (unwrapper.unwrappedElement != null) {
                XSElementDeclaration element = unwrapper.unwrappedElement;
                xt = element.getTypeDefinition();
                primitive = unwrapper.primitive;
                if (unwrapper.xmlType != null) {
                    xmlType = unwrapper.xmlType;
                }
                containingElement = containingElement + ToolsUtils.firstLetterUpperCase(unwrapper.unwrappedElement.getName());
                if (unwrapper.array) {
                    arraySuffix = "[]";
                }
            }
        }
        if ((wrappedArray = new WrappedArray(xt)).unwrap()) {
            xt = wrappedArray.xt;
            xmlType = wrappedArray.xmlType;
            primitive = !wrappedArray.nillable;
            arraySuffix = wrappedArray.suffix;
        }
        if (xt instanceof XSSimpleTypeDefinition) {
            xmlType = SchemaUtils.handleSimpleType((XSSimpleTypeDefinition)xt);
        }
        Class cls = this.getJavaType(xmlType, primitive);
        if (xt instanceof XSComplexTypeDefinition) {
            this.generateJavaSource((XSComplexTypeDefinition)xt, xsmodel, containingElement);
        }
        if (cls == null) {
            String className = xt.getAnonymous() ? containingElement : xmlType.getLocalPart();
            if (className.charAt(0) == '>') {
                className = className.substring(1);
            }
            className = ToolsUtils.convertInvalidCharacters(className);
            className = this.utils.firstLetterUpperCase(className);
            String packageName = this.getPackageName(xt.getNamespace());
            return packageName + "." + className + arraySuffix;
        }
        if (cls.isArray()) {
            return JavaUtils.getSourceName((Class)cls);
        }
        return cls.getName() + arraySuffix;
    }

    private void checkTypeMapping() {
        if (this.typeMapping == null) {
            throw new WSException("TypeMapping has not been set.");
        }
    }

    private Class getJavaType(QName qname, boolean primitive) {
        Class<SOAPElement> cls = this.typeMapping.getJavaType(qname, primitive);
        if (qname.getNamespaceURI().equals("http://www.w3.org/2001/XMLSchema") && "anyType".equals(qname.getLocalPart()) && cls == Element.class) {
            cls = SOAPElement.class;
        }
        return cls;
    }

    private String getMethodParam(String name) {
        String paramName = ToolsUtils.firstLetterLowerCase(name);
        if (JavaKeywords.isJavaKeyword(paramName)) {
            paramName = "_" + paramName;
        }
        return paramName;
    }

    private File getLocationForJavaGeneration(String packageName) {
        return new File(this.directoryToGenerate + "/" + packageName.replace('.', '/'));
    }

    private void generateJavaSource(XSComplexTypeDefinition xt, JBossXSModel xsmodel, String containingElement) throws IOException {
        this.generateJavaSource(xt, xsmodel, containingElement, false);
    }

    private void generateJavaSource(XSComplexTypeDefinition xt, JBossXSModel xsmodel, String containingElement, boolean exception) throws IOException {
        XSDTypeToJava xtj = new XSDTypeToJava(this.namespacePackageMap, this.generateSerializableTypes);
        xtj.setTypeMapping(this.typeMapping);
        String targetNS = this.wsdl.getTargetNamespace();
        String tgtNS = xt.getNamespace();
        String packName = this.getPackageName(tgtNS);
        if (!tgtNS.equals(targetNS)) {
            File dir = this.utils.createPackage(this.directoryToGenerate, packName);
        }
        xtj.createJavaFile(xt, containingElement, this.directoryToGenerate, packName, xsmodel, exception);
    }

    @Override
    public void setParameterStyle(String paramStyle) {
        this.parameterStyle = paramStyle;
    }

    private String getPackageName(String targetNamespace) {
        String pkg;
        if (this.namespacePackageMap != null && (pkg = this.namespacePackageMap.get(targetNamespace)) != null) {
            return pkg;
        }
        return this.seiPkgName;
    }

    private class WrappedArray {
        public QName xmlType;
        public XSTypeDefinition xt;
        public String suffix;
        public boolean nillable;

        public WrappedArray(XSTypeDefinition xt) {
            this.xt = xt;
        }

        public boolean unwrap() {
            if (!"Document/Literal".equals(WSDLToJava.this.style)) {
                XSElementDeclaration unwrapped = SchemaUtils.unwrapArrayType(this.xt);
                StringBuilder builder = new StringBuilder();
                while (unwrapped != null) {
                    this.xt = unwrapped.getTypeDefinition();
                    this.nillable = unwrapped.getNillable();
                    builder.append("[]");
                    unwrapped = SchemaUtils.unwrapArrayType(this.xt);
                }
                if (builder.length() > 0) {
                    this.xmlType = new QName(this.xt.getNamespace(), this.xt.getName());
                    this.suffix = builder.toString();
                    return true;
                }
            }
            return false;
        }
    }
}

