/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ws.tools.config;

import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    SecurityActions() {
    }

    static ClassLoader getContextClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static URL getResource(final ClassLoader cl, final String filename) {
        SecurityManager sm = System.getSecurityManager();
        if (sm == null) {
            return cl.getResource(filename);
        }
        return AccessController.doPrivileged(new PrivilegedAction<URL>(){

            @Override
            public URL run() {
                return cl.getResource(filename);
            }
        });
    }
}

