/*
 * Decompiled with CFR 0.152.
 */
package gnu.trove.decorator;

import gnu.trove.TLongFloatHashMap;
import gnu.trove.TLongFloatIterator;
import gnu.trove.decorator.TLongFloatHashMapDecorator;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class TLongFloatHashMapDecorator
extends AbstractMap
implements Map {
    protected final TLongFloatHashMap _map;

    public Object put(Object key, Object value) {
        return this.wrapValue(this._map.put(this.unwrapKey(key), this.unwrapValue(value)));
    }

    public boolean equals(Object other) {
        if (this._map.equals(other)) {
            return true;
        }
        if (other instanceof Map) {
            Map that = (Map)other;
            if (that.size() != this._map.size()) {
                return false;
            }
            Iterator it = that.entrySet().iterator();
            int i = that.size();
            while (i-- > 0) {
                Map.Entry e = it.next();
                Object key = e.getKey();
                Object val = e.getValue();
                if (key instanceof Integer && val instanceof Integer) {
                    long k = this.unwrapKey(key);
                    float v = this.unwrapValue(val);
                    if (this._map.containsKey(k) && v == this._map.get(k)) continue;
                    return false;
                }
                return false;
            }
            return true;
        }
        return false;
    }

    public Object get(Object key) {
        long k = this.unwrapKey(key);
        float v = this._map.get(k);
        if (v == 0.0f) {
            return this._map.containsKey(k) ? this.wrapValue(v) : null;
        }
        return this.wrapValue(v);
    }

    public void clear() {
        this._map.clear();
    }

    public Object remove(Object key) {
        return this.wrapValue(this._map.remove(this.unwrapKey(key)));
    }

    public Set entrySet() {
        return new AbstractSet(this){
            final /* synthetic */ TLongFloatHashMapDecorator this$0;

            public final int size() {
                return this.this$0._map.size();
            }

            public final boolean isEmpty() {
                return this.this$0.isEmpty();
            }

            public final boolean contains(Object o) {
                if (o instanceof Map.Entry) {
                    K k = ((Map.Entry)o).getKey();
                    V v = ((Map.Entry)o).getValue();
                    boolean bl = false;
                    if (this.this$0.containsKey(k) && this.this$0.get(k).equals(v)) {
                        bl = true;
                    }
                    return bl;
                }
                return false;
            }

            public final Iterator iterator() {
                return new Iterator(this){
                    private final TLongFloatIterator it;
                    final /* synthetic */ 1 this$0;

                    public final Object next() {
                        this.it.advance();
                        Long key = this.this$0.this$0.wrapKey(this.it.key());
                        Float v = this.this$0.this$0.wrapValue(this.it.value());
                        return new Map.Entry(this, v, key){
                            private Object val;
                            final /* synthetic */ 1 this$0;
                            final /* synthetic */ Object val$v;
                            final /* synthetic */ Object val$key;

                            public final boolean equals(Object o) {
                                boolean bl = false;
                                if (o instanceof Map.Entry && ((Map.Entry)o).getKey().equals(this.val$key) && ((Map.Entry)o).getValue().equals(this.val)) {
                                    bl = true;
                                }
                                return bl;
                            }

                            public final Object getKey() {
                                return this.val$key;
                            }

                            public final Object getValue() {
                                return this.val;
                            }

                            public final int hashCode() {
                                return this.val$key.hashCode() + this.val.hashCode();
                            }

                            public final Object setValue(Object value) {
                                this.val = value;
                                return this.this$0.this$0.this$0.put(this.val$key, value);
                            }

                            private final /* synthetic */ void this() {
                                this.val = this.val$v;
                            }
                            {
                                this.this$0 = var1_1;
                                this.val$v = object;
                                this.val$key = object2;
                                this.this();
                            }
                        };
                    }

                    public final boolean hasNext() {
                        return this.it.hasNext();
                    }

                    public final void remove() {
                        this.it.remove();
                    }

                    private final /* synthetic */ void this() {
                        this.it = this.this$0.this$0._map.iterator();
                    }
                    {
                        this.this$0 = var1_1;
                        this.this();
                    }
                };
            }

            public final boolean add(Object o) {
                throw new UnsupportedOperationException();
            }

            public final boolean remove(Object o) {
                throw new UnsupportedOperationException();
            }

            public final boolean addAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            public final boolean retainAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            public final boolean removeAll(Collection c) {
                throw new UnsupportedOperationException();
            }

            public final void clear() {
                this.this$0.clear();
            }
            {
                this.this$0 = tLongFloatHashMapDecorator;
            }
        };
    }

    public boolean containsValue(Object val) {
        return this._map.containsValue(this.unwrapValue(val));
    }

    public boolean containsKey(Object key) {
        return this._map.containsKey(this.unwrapKey(key));
    }

    public int size() {
        return this._map.size();
    }

    public boolean isEmpty() {
        boolean bl = false;
        if (this.size() == 0) {
            bl = true;
        }
        return bl;
    }

    public void putAll(Map map) {
        Iterator it = map.entrySet().iterator();
        int i = map.size();
        while (i-- > 0) {
            Map.Entry e = it.next();
            this.put(e.getKey(), e.getValue());
        }
    }

    protected Long wrapKey(long k) {
        return new Long(k);
    }

    protected long unwrapKey(Object key) {
        return (Long)key;
    }

    protected Float wrapValue(float k) {
        return new Float(k);
    }

    protected float unwrapValue(Object value) {
        return ((Float)value).floatValue();
    }

    public TLongFloatHashMapDecorator(TLongFloatHashMap map) {
        this._map = map;
    }
}

