/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.arjuna.abstractrecords;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.common.arjPropertyManager;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.OnePhaseResource;
import com.arjuna.ats.arjuna.logging.tsLogger;
import java.io.PrintWriter;

public class LastResourceRecord
extends AbstractRecord {
    private OnePhaseResource _lro;
    private static final Uid ONE_PHASE_RESOURCE_UID = Uid.lastResourceUid();
    private static final boolean ALLOW_MULTIPLE_LAST_RESOURCES;
    private static boolean _disableMLRWarning;
    private static boolean _issuedWarning;

    public LastResourceRecord(OnePhaseResource opr) {
        super(ONE_PHASE_RESOURCE_UID);
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)"LastResourceRecord()");
        }
        this._lro = opr;
    }

    @Override
    public boolean propagateOnCommit() {
        return false;
    }

    @Override
    public int typeIs() {
        return Integer.MAX_VALUE;
    }

    @Override
    public int nestedAbort() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("LastResourceRecord::nestedAbort() for " + this.order()));
        }
        return 7;
    }

    @Override
    public int nestedCommit() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("LastResourceRecord::nestedCommit() for " + this.order()));
        }
        return 8;
    }

    @Override
    public int nestedPrepare() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("LastResourceRecord::nestedPrepare() for " + this.order()));
        }
        return 1;
    }

    @Override
    public int topLevelAbort() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("LastResourceRecord::topLevelAbort() for " + this.order()));
        }
        if (this._lro != null) {
            return this._lro.rollback();
        }
        return 7;
    }

    @Override
    public int topLevelCommit() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("LastResourceRecord::topLevelCommit() for " + this.order()));
        }
        return 7;
    }

    @Override
    public int topLevelPrepare() {
        if (tsLogger.logger.isTraceEnabled()) {
            tsLogger.logger.trace((Object)("LastResourceRecord::topLevelPrepare() for " + this.order()));
        }
        if (this._lro == null) {
            return 1;
        }
        switch (this._lro.commit()) {
            case 7: {
                return 0;
            }
            case 10: {
                return 10;
            }
        }
        return 1;
    }

    @Override
    public void print(PrintWriter strm) {
        strm.println("LastResource for:");
        super.print(strm);
    }

    @Override
    public String type() {
        return "/StateManager/AbstractRecord/LastResourceRecord";
    }

    @Override
    public boolean shouldAdd(AbstractRecord a) {
        if (a.typeIs() == this.typeIs()) {
            if (ALLOW_MULTIPLE_LAST_RESOURCES) {
                if (!_disableMLRWarning || _disableMLRWarning && !_issuedWarning) {
                    tsLogger.i18NLogger.warn_lastResource_multipleWarning(a.toString());
                    _issuedWarning = true;
                }
                return true;
            }
            tsLogger.i18NLogger.warn_lastResource_disallow(a.toString());
            return false;
        }
        return true;
    }

    @Override
    public boolean shouldMerge(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldReplace(AbstractRecord a) {
        return false;
    }

    @Override
    public boolean shouldAlter(AbstractRecord a) {
        return false;
    }

    @Override
    public void merge(AbstractRecord a) {
    }

    @Override
    public void alter(AbstractRecord a) {
    }

    @Override
    public Object value() {
        return this._lro;
    }

    @Override
    public void setValue(Object o) {
    }

    public LastResourceRecord() {
        this._lro = null;
    }

    static {
        _disableMLRWarning = false;
        _issuedWarning = false;
        ALLOW_MULTIPLE_LAST_RESOURCES = arjPropertyManager.getCoreEnvironmentBean().isAllowMultipleLastResources();
        if (ALLOW_MULTIPLE_LAST_RESOURCES) {
            tsLogger.i18NLogger.warn_lastResource_startupWarning();
        }
        _disableMLRWarning = arjPropertyManager.getCoreEnvironmentBean().isDisableMultipleLastResourcesWarning();
        if (arjPropertyManager.getCoreEnvironmentBean().isDisableMultipleLastResourcesWarning()) {
            tsLogger.i18NLogger.warn_lastResource_disableWarning();
            _disableMLRWarning = true;
        }
    }
}

