/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.recovery.transactions;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.exceptions.ObjectStoreException;
import com.arjuna.ats.arjuna.recovery.RecoveryModule;
import com.arjuna.ats.internal.jts.orbspecific.interposition.coordinator.ServerTransaction;
import com.arjuna.ats.internal.jts.recovery.transactions.CachedRecoveredTransaction;
import com.arjuna.ats.internal.jts.recovery.transactions.TransactionRecoveryModule;
import com.arjuna.ats.jts.logging.jtsLogger;
import com.arjuna.ats.jts.utils.Utility;
import java.util.Enumeration;
import org.omg.CosTransactions.Status;

public class ServerTransactionRecoveryModule
extends TransactionRecoveryModule
implements RecoveryModule {
    public ServerTransactionRecoveryModule() {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug((Object)"ServerTransactionRecoveryModule created");
        }
        if (this._transactionType == null) {
            this._transactionType = ServerTransaction.typeName();
        }
    }

    @Override
    public void periodicWorkFirstPass() {
        jtsLogger.i18NLogger.info_recovery_transactions_ServerTransactionRecoveryModule_3();
        super.periodicWorkFirstPass();
    }

    @Override
    public void periodicWorkSecondPass() {
        jtsLogger.i18NLogger.info_recovery_transactions_ServerTransactionRecoveryModule_4();
        Enumeration transactionUidEnum = this._transactionUidVector.elements();
        while (transactionUidEnum.hasMoreElements()) {
            Uid currentUid = (Uid)transactionUidEnum.nextElement();
            try {
                if (_recoveryStore.currentState(currentUid, this._transactionType) != -1) {
                    jtsLogger.i18NLogger.info_recovery_transactions_ServerTransactionRecoveryModule_5(currentUid);
                    this.recoverTransaction(currentUid);
                    continue;
                }
                if (!jtsLogger.logger.isDebugEnabled()) continue;
                jtsLogger.logger.debug((Object)("ServerTransactionRecoveryModule - Transaction " + currentUid + " still in state unknown (?)."));
            }
            catch (ObjectStoreException e4) {
                if (!jtsLogger.logger.isDebugEnabled()) continue;
                jtsLogger.logger.debug((Object)("ServerTransactionRecoveryModule - Transaction " + currentUid + " is not in object store - assumed completed"));
            }
        }
    }

    @Override
    protected void initialise() {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug((Object)"ServerTransactionRecoveryModule.initialise()");
        }
        super.initialise();
    }

    protected void recoverTransaction(Uid tranUid) {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug((Object)("ServerTransactionRecoveryModule.recoverTransaction()" + tranUid + ")"));
        }
        Status currentStatus = Status.StatusUnknown;
        CachedRecoveredTransaction cachedRecoveredTransaction = new CachedRecoveredTransaction(tranUid, this._transactionType);
        currentStatus = cachedRecoveredTransaction.get_status();
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug((Object)("Activated transaction " + tranUid + " status = " + Utility.stringStatus(currentStatus)));
        }
        if (cachedRecoveredTransaction.originalBusy() && currentStatus != Status.StatusPrepared) {
            if (jtsLogger.logger.isDebugEnabled()) {
                jtsLogger.logger.debug((Object)("Transaction " + tranUid + " still busy"));
            }
            return;
        }
        cachedRecoveredTransaction.replayPhase2();
        cachedRecoveredTransaction = null;
    }
}

