/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ha.framework.server;

import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.Name;
import javax.naming.NameNotFoundException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import org.jboss.beans.metadata.api.annotations.Create;
import org.jboss.beans.metadata.api.annotations.Destroy;
import org.jboss.beans.metadata.api.annotations.Start;
import org.jboss.beans.metadata.api.annotations.Stop;
import org.jboss.dependency.spi.Controller;
import org.jboss.dependency.spi.ControllerContext;
import org.jboss.dependency.spi.ControllerState;
import org.jboss.ha.core.framework.server.DistributedReplicantManagerImpl;
import org.jboss.ha.core.framework.server.HAPartitionImpl;
import org.jboss.ha.framework.interfaces.HAPartition;
import org.jboss.ha.framework.server.ClusterPartitionMBean;
import org.jboss.ha.framework.server.HAPartitionLocator;
import org.jboss.ha.framework.server.deployers.DefaultHAPartitionDependencyCreator;
import org.jboss.ha.framework.server.deployers.HAPartitionDependencyCreator;
import org.jboss.ha.framework.server.spi.HAPartitionCacheHandler;
import org.jboss.kernel.spi.dependency.KernelController;
import org.jboss.kernel.spi.dependency.KernelControllerContext;
import org.jboss.kernel.spi.dependency.KernelControllerContextAware;
import org.jboss.managed.api.ManagedOperation;
import org.jboss.managed.api.annotation.ManagementComponent;
import org.jboss.managed.api.annotation.ManagementObject;
import org.jboss.managed.api.annotation.ManagementObjectID;
import org.jboss.managed.api.annotation.ManagementOperation;
import org.jboss.managed.api.annotation.ManagementParameter;
import org.jboss.managed.api.annotation.ManagementProperties;
import org.jboss.managed.api.annotation.ManagementProperty;
import org.jboss.managed.api.annotation.ViewUse;
import org.jboss.naming.NonSerializableFactory;
import org.jboss.util.Classes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@ManagementObject(componentType=@ManagementComponent(type="MCBean", subtype="HAPartition"), properties=ManagementProperties.CLASS_AND_EXPLICIT, classProperties={@ManagementProperty(name="stateString", use={ViewUse.STATISTIC})}, isRuntime=true)
public class ClusterPartition
extends HAPartitionImpl
implements ClusterPartitionMBean,
KernelControllerContextAware {
    private boolean bindIntoJndi = true;
    private HAPartitionDependencyCreator haPartitionDependencyCreator;
    private KernelControllerContext kernelControllerContext;
    private HAPartitionCacheHandler cacheHandler;

    public ClusterPartition() {
        this.logHistory("Partition object created");
    }

    protected void createService() throws Exception {
        super.createService();
        this.addCanonicalAlias();
    }

    protected void startService() throws Exception {
        super.startService();
        HAPartitionLocator.getHAPartitionLocator().registerHAPartition((HAPartition)this);
        if (this.bindIntoJndi) {
            InitialContext ctx = new InitialContext();
            this.bind(HAPartitionLocator.getStandardJndiBinding((String)this.getPartitionName()), this, ClusterPartition.class, ctx);
            this.log.debug((Object)("Bound in JNDI under /HAPartition/" + this.getPartitionName()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void stopService() throws Exception {
        super.stopService();
        if (this.bindIntoJndi) {
            String boundName = HAPartitionLocator.getStandardJndiBinding((String)this.getPartitionName());
            InitialContext ctx = null;
            try {
                ctx = new InitialContext();
                ctx.unbind(boundName);
            }
            catch (Exception e) {
                this.log.error((Object)"partition unbind operation failed", (Throwable)e);
            }
            finally {
                if (ctx != null) {
                    ctx.close();
                }
            }
            NonSerializableFactory.unbind((String)boundName);
        }
        HAPartitionLocator.getHAPartitionLocator().deregisterHAPartition((HAPartition)this);
    }

    protected void destroyService() {
        this.removeCanonicalAlias();
        super.destroyService();
    }

    private void addCanonicalAlias() {
        if (this.kernelControllerContext != null) {
            KernelController kc = (KernelController)this.kernelControllerContext.getController();
            String aliasName = this.getHaPartitionDependencyCreator().getHAPartitionDependencyName(this.getPartitionName());
            try {
                kc.addAlias((Object)aliasName, this.kernelControllerContext.getName());
            }
            catch (Throwable t) {
                this.log.error((Object)("Failed adding alias " + aliasName + " to context " + this.kernelControllerContext.getName()), t);
            }
        }
    }

    private void removeCanonicalAlias() {
        if (this.kernelControllerContext != null) {
            KernelController kc = (KernelController)this.kernelControllerContext.getController();
            String aliasName = this.getHaPartitionDependencyCreator().getHAPartitionDependencyName(this.getPartitionName());
            Set aliases = this.kernelControllerContext.getAliases();
            if (aliases != null && aliases.contains(aliasName)) {
                try {
                    kc.removeAlias((Object)aliasName);
                }
                catch (Throwable t) {
                    this.log.error((Object)("Failed removing alias " + aliasName + " from context " + this.kernelControllerContext.getName()), t);
                }
            }
        }
    }

    @Override
    @ManagementProperty(use={ViewUse.STATISTIC}, description="The identifier for this node in cluster topology views")
    public String getNodeName() {
        return super.getNodeName();
    }

    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="Deprecated, legacy term for group name")
    @ManagementObjectID(type="HAPartition")
    public String getGroupName() {
        return super.getGroupName();
    }

    @Override
    @ManagementProperty(use={ViewUse.CONFIGURATION}, description="Deprecated, legacy term for group name")
    @ManagementObjectID(type="HAPartition")
    public String getPartitionName() {
        return super.getPartitionName();
    }

    @ManagementProperty(use={ViewUse.STATISTIC}, description="Identifier for the current topology view")
    public long getCurrentViewId() {
        return super.getCurrentViewId();
    }

    @ManagementProperty(use={ViewUse.STATISTIC}, description="The current cluster topology view")
    public Vector<String> getCurrentView() {
        return super.getCurrentView();
    }

    @ManagementProperty(use={ViewUse.STATISTIC}, description="Whether this node is acting as the group coordinator for the partition")
    public boolean isCurrentNodeCoordinator() {
        return super.isCurrentNodeCoordinator();
    }

    @Override
    @ManagementProperty(use={ViewUse.CONFIGURATION, ViewUse.RUNTIME}, description="Whether to allow synchronous notifications of topology changes")
    public boolean getAllowSynchronousMembershipNotifications() {
        return super.getAllowSynchronousMembershipNotifications();
    }

    protected void bind(String jndiName, Object who, Class<?> classType, Context ctx) throws Exception {
        NonSerializableFactory.bind((String)jndiName, (Object)who);
        Name n = ctx.getNameParser("").parse(jndiName);
        while (n.size() > 1) {
            String ctxName = n.get(0);
            try {
                ctx = (Context)ctx.lookup(ctxName);
            }
            catch (NameNotFoundException e) {
                this.log.debug((Object)("creating Subcontext " + ctxName));
                ctx = ctx.createSubcontext(ctxName);
            }
            n = n.getSuffix(1);
        }
        StringRefAddr addr = new StringRefAddr("nns", jndiName);
        Reference ref = new Reference(classType.getName(), addr, NonSerializableFactory.class.getName(), null);
        ctx.rebind(n.get(0), (Object)ref);
    }

    public void setBindIntoJndi(boolean bind) {
        this.bindIntoJndi = bind;
    }

    @ManagementProperty(description="Whether this HAPartition should bind itself into JNDI")
    public boolean getBindIntoJndi() {
        return this.bindIntoJndi;
    }

    public synchronized HAPartitionDependencyCreator getHaPartitionDependencyCreator() {
        if (this.haPartitionDependencyCreator == null) {
            this.haPartitionDependencyCreator = DefaultHAPartitionDependencyCreator.INSTANCE;
        }
        return this.haPartitionDependencyCreator;
    }

    public synchronized void setHaPartitionDependencyCreator(HAPartitionDependencyCreator haPartitionDependencyCreator) {
        this.haPartitionDependencyCreator = haPartitionDependencyCreator;
    }

    @Override
    @ManagementOperation(description="Gets a listing of significant events since the instantiation of this service", impact=ManagedOperation.Impact.ReadOnly)
    public String showHistory() {
        return super.showHistory();
    }

    @Override
    @ManagementOperation(description="Gets an XML format listing of significant events since the instantiation of this service", impact=ManagedOperation.Impact.ReadOnly)
    public String showHistoryAsXML() {
        return super.showHistoryAsXML();
    }

    @Override
    @ManagementProperty(use={ViewUse.STATISTIC}, description="The release version of JGroups")
    public String getJGroupsVersion() {
        return super.getJGroupsVersion();
    }

    @Override
    @ManagementProperty(use={ViewUse.STATISTIC}, description="Name of the CacheManager configuration used for deriving the JGroups channel stack name")
    public String getCacheConfigName() {
        return this.cacheHandler == null ? null : this.cacheHandler.getCacheConfigName();
    }

    @Override
    @ManagementProperty(use={ViewUse.STATISTIC}, description="Name of the JGroups protocol stack configuration")
    public String getChannelStackName() {
        return this.cacheHandler == null ? super.getChannelStackName() : this.cacheHandler.getChannelStackName();
    }

    @Override
    @ManagementProperty(description="Time (in ms) to allow for state transfer to finish")
    public long getStateTransferTimeout() {
        return super.getStateTransferTimeout();
    }

    @Override
    @ManagementProperty(use={ViewUse.CONFIGURATION, ViewUse.RUNTIME}, description="Time (in ms) to allow for group RPCs to return")
    public long getMethodCallTimeout() {
        return super.getMethodCallTimeout();
    }

    @Override
    public String getName() {
        return Classes.stripPackageName((String)this.log.getName());
    }

    public void setKernelControllerContext(KernelControllerContext controllerContext) throws Exception {
        this.kernelControllerContext = controllerContext;
    }

    public void unsetKernelControllerContext(KernelControllerContext controllerContext) throws Exception {
        this.kernelControllerContext = null;
    }

    @ManagementOperation(description="Create the HAPartition", impact=ManagedOperation.Impact.WriteOnly)
    public void create() throws Exception {
        if (this.kernelControllerContext != null) {
            this.pojoChange(ControllerState.CREATE);
        } else {
            super.create();
        }
    }

    @ManagementOperation(description="Start the HAPartition", impact=ManagedOperation.Impact.WriteOnly)
    public void start() throws Exception {
        if (this.kernelControllerContext != null) {
            this.pojoChange(ControllerState.START);
        } else {
            super.start();
        }
    }

    @ManagementOperation(description="Stop the HAPartition", impact=ManagedOperation.Impact.WriteOnly)
    public void stop() {
        if (this.kernelControllerContext != null) {
            this.pojoChange(ControllerState.CREATE);
        } else {
            super.stop();
        }
    }

    @ManagementOperation(description="Destroy the HAPartition", impact=ManagedOperation.Impact.WriteOnly)
    public void destroy() {
        if (this.kernelControllerContext != null) {
            this.pojoChange(ControllerState.CONFIGURED);
        } else {
            super.destroy();
        }
    }

    @ManagementOperation(description="List all known DistributedReplicantManager keys and the nodes that have registered bindings", impact=ManagedOperation.Impact.ReadOnly)
    public String listDRMContent() throws Exception {
        DistributedReplicantManagerImpl drm = this.getDistributedReplicantManagerImpl();
        return drm == null ? null : drm.listContent();
    }

    @ManagementOperation(description="List in XML format all known DistributedReplicantManager keys and the nodes that have registered bindings", impact=ManagedOperation.Impact.ReadOnly)
    public String listDRMContentAsXml() throws Exception {
        DistributedReplicantManagerImpl drm = this.getDistributedReplicantManagerImpl();
        return drm == null ? null : drm.listXmlContent();
    }

    @ManagementOperation(description="Returns the names of the nodes that have registered objects with the DistributedReplicantManager under the given key", impact=ManagedOperation.Impact.ReadOnly, params={@ManagementParameter(name="key", description="The name of the service")})
    public List<String> lookupDRMNodeNames(String key) {
        DistributedReplicantManagerImpl drm = this.getDistributedReplicantManagerImpl();
        return drm == null ? null : drm.lookupReplicantsNodeNames(key);
    }

    @ManagementOperation(description="Returns a hash of the list of nodes that have registered an object with the DistributedReplicantManager under  the given key", impact=ManagedOperation.Impact.ReadOnly, params={@ManagementParameter(name="key", description="The name of the service")})
    public int getDRMServiceViewId(String key) {
        DistributedReplicantManagerImpl drm = this.getDistributedReplicantManagerImpl();
        return drm == null ? null : Integer.valueOf(drm.getReplicantsViewId(key));
    }

    @ManagementOperation(description="Returns whether the DistributedReplicantManager considers this node to be the master for the given service", impact=ManagedOperation.Impact.ReadOnly, params={@ManagementParameter(name="key", description="The name of the service")})
    public boolean isDRMMasterForService(String key) {
        DistributedReplicantManagerImpl drm = this.getDistributedReplicantManagerImpl();
        return drm == null ? null : Boolean.valueOf(drm.isMasterReplica(key));
    }

    @ManagementOperation(description="Get a collection of the names of all keys for which the DistributedReplicantManager has bindings", impact=ManagedOperation.Impact.ReadOnly)
    public Collection<String> getDRMServiceNames() {
        DistributedReplicantManagerImpl drm = this.getDistributedReplicantManagerImpl();
        return drm == null ? null : drm.getAllServices();
    }

    public void setCacheHandler(HAPartitionCacheHandler handler) {
        this.cacheHandler = handler;
    }

    @Create
    public void pojoCreate() throws Exception {
        super.create();
    }

    @Start
    public void pojoStart() throws Exception {
        super.start();
    }

    @Stop
    public void pojoStop() throws Exception {
        super.stop();
    }

    @Destroy
    public void pojoDestroy() throws Exception {
        super.destroy();
    }

    private void pojoChange(ControllerState state) {
        Controller controller = this.kernelControllerContext.getController();
        try {
            controller.change((ControllerContext)this.kernelControllerContext, state);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable t) {
            throw new RuntimeException("Error changing state of " + this.kernelControllerContext.getName() + " to " + state.getStateString(), t);
        }
    }
}

