/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployers.vfs.plugins.client;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.jboss.deployers.client.plugins.deployment.AbstractDeployment;
import org.jboss.deployers.vfs.spi.client.VFSDeployment;
import org.jboss.vfs.VirtualFile;

public class AbstractVFSDeployment
extends AbstractDeployment
implements VFSDeployment,
Externalizable {
    private static final long serialVersionUID = 2L;
    private VirtualFile root;

    static String safeVirtualFileName(VirtualFile root) {
        if (root == null) {
            throw new IllegalArgumentException("Null root");
        }
        try {
            return root.toURI().toString();
        }
        catch (Exception e) {
            return root.getName();
        }
    }

    public AbstractVFSDeployment() {
    }

    public AbstractVFSDeployment(VirtualFile root) {
        super(AbstractVFSDeployment.safeVirtualFileName(root));
        this.root = root;
    }

    public AbstractVFSDeployment(String name, VirtualFile root) {
        super(name);
        this.root = root;
    }

    public VirtualFile getRoot() {
        return this.root;
    }

    public String getSimpleName() {
        return this.getRoot().getName();
    }

    public String toString() {
        return "AbstractVFSDeployment(" + this.getSimpleName() + ")";
    }

    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.root = (VirtualFile)in.readObject();
    }

    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeObject(this.root);
    }
}

