/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.deployment;

import java.util.ArrayList;
import java.util.List;
import org.jboss.deployers.spi.deployer.helpers.AbstractComponentDeployer;
import org.jboss.deployers.spi.deployer.helpers.AbstractDeploymentVisitor;
import org.jboss.deployers.spi.deployer.helpers.DeploymentVisitor;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployment.DeploymentException;
import org.jboss.logging.Logger;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeanMetaData;
import org.jboss.metadata.ejb.jboss.JBossEnterpriseBeansMetaData;
import org.jboss.metadata.ejb.jboss.JBossMetaData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Ejb2xComponentDeployer
extends AbstractComponentDeployer<JBossMetaData, JBossEnterpriseBeanMetaData> {
    private static final Logger log = Logger.getLogger(Ejb2xComponentDeployer.class);
    private static final JBossDeploymentVisitor deploymentVisitor = new JBossDeploymentVisitor();
    private static final String attachmentName = JBossMetaData.class.getName();

    public Ejb2xComponentDeployer() {
        this.setInput(JBossMetaData.class);
        this.setOutput(deploymentVisitor.getComponentType());
        this.setDeploymentVisitor((DeploymentVisitor)deploymentVisitor);
    }

    protected <U> void deploy(DeploymentUnit unit, DeploymentVisitor<U> visitor) throws DeploymentException {
        Object deployment = unit.getAttachment(attachmentName, visitor.getVisitorType());
        try {
            visitor.deploy(unit, deployment);
        }
        catch (Throwable t) {
            throw DeploymentException.rethrowAsDeploymentException((String)("Error deploying: " + unit.getName()), (Throwable)t);
        }
    }

    protected <U> void undeploy(DeploymentUnit unit, DeploymentVisitor<U> visitor) {
        if (visitor == null) {
            return;
        }
        Object deployment = unit.getAttachment(attachmentName, visitor.getVisitorType());
        visitor.undeploy(unit, deployment);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JBossDeploymentVisitor
    extends AbstractDeploymentVisitor<JBossEnterpriseBeanMetaData, JBossMetaData> {
        private JBossDeploymentVisitor() {
        }

        public Class<JBossEnterpriseBeanMetaData> getComponentType() {
            return JBossEnterpriseBeanMetaData.class;
        }

        protected List<? extends JBossEnterpriseBeanMetaData> getComponents(JBossMetaData deployment) {
            if (deployment == null || !deployment.isEJB2x()) {
                return null;
            }
            JBossEnterpriseBeansMetaData enterpriseBeans = deployment.getEnterpriseBeans();
            if (enterpriseBeans == null) {
                return null;
            }
            return new ArrayList(enterpriseBeans);
        }

        protected String getComponentName(JBossEnterpriseBeanMetaData attachment) {
            return JBossEnterpriseBeanMetaData.class.getName() + "." + attachment.getEjbName();
        }

        public Class<JBossMetaData> getVisitorType() {
            return JBossMetaData.class;
        }
    }
}

