/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins;

import java.util.HashMap;
import org.jboss.deployment.DeploymentException;
import org.jboss.ejb.EnterpriseContext;
import org.jboss.ejb.plugins.AbstractInstanceCache;
import org.jboss.metadata.MetaData;
import org.jboss.metadata.XmlLoadable;
import org.jboss.monitor.Monitorable;
import org.jboss.monitor.client.BeanCacheSnapshot;
import org.jboss.util.CachePolicy;
import org.w3c.dom.Element;

public class NoPassivationCachePolicy
implements CachePolicy,
Monitorable,
XmlLoadable {
    private HashMap m_map;
    private boolean flushEnabled = false;

    public NoPassivationCachePolicy(AbstractInstanceCache eic) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sample(Object s) {
        if (this.m_map == null) {
            return;
        }
        HashMap hashMap = this.m_map;
        synchronized (hashMap) {
            BeanCacheSnapshot snapshot = (BeanCacheSnapshot)s;
            snapshot.m_passivatingBeans = 0;
            snapshot.m_cacheMinCapacity = 0;
            snapshot.m_cacheMaxCapacity = Integer.MAX_VALUE;
            snapshot.m_cacheCapacity = Integer.MAX_VALUE;
            snapshot.m_cacheSize = this.m_map.size();
        }
    }

    public void create() throws Exception {
        this.m_map = new HashMap();
    }

    public void start() throws Exception {
    }

    public void stop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        HashMap hashMap = this.m_map;
        synchronized (hashMap) {
            this.m_map.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object get(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Requesting an object using a null key");
        }
        EnterpriseContext ctx = null;
        HashMap hashMap = this.m_map;
        synchronized (hashMap) {
            ctx = (EnterpriseContext)this.m_map.get(key);
        }
        return ctx;
    }

    public Object peek(Object key) {
        return this.get(key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Object key, Object ctx) {
        if (ctx == null) {
            throw new IllegalArgumentException("Cannot insert a null object in the cache");
        }
        if (key == null) {
            throw new IllegalArgumentException("Cannot insert an object in the cache with null key");
        }
        HashMap hashMap = this.m_map;
        synchronized (hashMap) {
            Object obj = this.m_map.get(key);
            if (obj != null) {
                throw new IllegalStateException("Attempt to put in the cache an object that is already there");
            }
            this.m_map.put(key, ctx);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(Object key) {
        if (key == null) {
            throw new IllegalArgumentException("Removing an object using a null key");
        }
        HashMap hashMap = this.m_map;
        synchronized (hashMap) {
            Object value = this.m_map.get(key);
            if (value == null) {
                throw new IllegalArgumentException("Cannot remove an object that isn't in the cache");
            }
            this.m_map.remove(key);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flush() {
        if (this.flushEnabled) {
            HashMap hashMap = this.m_map;
            synchronized (hashMap) {
                this.m_map.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        HashMap hashMap = this.m_map;
        synchronized (hashMap) {
            return this.m_map.size();
        }
    }

    public void importXml(Element element) throws DeploymentException {
        String flushString = MetaData.getElementContent((Element)MetaData.getOptionalChild((Element)element, (String)"flush-enabled"));
        this.flushEnabled = Boolean.valueOf(flushString);
    }
}

