/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb.plugins.lock;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import javax.transaction.Transaction;
import org.jboss.ejb.Container;
import org.jboss.ejb.EntityEnterpriseContext;
import org.jboss.ejb.plugins.lock.BeanLockSupport;
import org.jboss.invocation.Invocation;
import org.jboss.monitor.LockMonitor;
import org.jboss.tm.TxUtils;
import org.jboss.util.deadlock.DeadlockDetector;
import org.jboss.util.deadlock.Resource;

public class QueuedPessimisticEJBLock
extends BeanLockSupport {
    private HashMap txLocks = new HashMap();
    private LinkedList txWaitQueue = new LinkedList();
    private int txIdGen = 0;
    protected LockMonitor lockMonitor = null;
    protected boolean deadlockDetection = true;

    public void setContainer(Container container) {
        this.container = container;
        this.lockMonitor = container.getLockManager().getLockMonitor();
    }

    public boolean getDeadlockDetection() {
        return this.deadlockDetection;
    }

    public void setDeadlockDetection(boolean flag) {
        this.deadlockDetection = flag;
    }

    protected TxLock getTxLock(Transaction miTx) {
        TxLock lock = null;
        if (miTx == null) {
            lock = new TxLock(null);
            this.txWaitQueue.addLast(lock);
        } else {
            TxLock key = new TxLock(miTx);
            lock = (TxLock)this.txLocks.get(key);
            if (lock == null) {
                this.txLocks.put(key, key);
                this.txWaitQueue.addLast(key);
                lock = key;
            }
        }
        return lock;
    }

    protected boolean isTxExpired(Transaction miTx) throws Exception {
        return TxUtils.isRollback((Transaction)miTx);
    }

    public void schedule(Invocation mi) throws Exception {
        boolean threadScheduled = false;
        while (!threadScheduled) {
            threadScheduled = this.doSchedule(mi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doSchedule(Invocation mi) throws Exception {
        boolean wasThreadScheduled = false;
        Transaction miTx = mi.getTransaction();
        boolean trace = log.isTraceEnabled();
        this.sync();
        try {
            if (trace) {
                log.trace((Object)("Begin schedule, key=" + mi.getId()));
            }
            if (this.isTxExpired(miTx)) {
                log.error((Object)("Saw rolled back tx=" + miTx));
                throw new RuntimeException("Transaction marked for rollback, possibly a timeout");
            }
            long startWait = System.currentTimeMillis();
            try {
                wasThreadScheduled = this.waitForTx(miTx, trace);
                if (wasThreadScheduled && this.lockMonitor != null) {
                    long endWait = System.currentTimeMillis() - startWait;
                    this.lockMonitor.finishedContending(endWait);
                }
            }
            catch (Exception throwable) {
                if (this.lockMonitor != null && this.isTxExpired(miTx)) {
                    this.lockMonitor.increaseTimeouts();
                }
                if (this.lockMonitor != null) {
                    long endWait = System.currentTimeMillis() - startWait;
                    this.lockMonitor.finishedContending(endWait);
                }
                throw throwable;
            }
        }
        finally {
            if (miTx == null && wasThreadScheduled) {
                this.nextTransaction();
            }
            this.releaseSync();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean waitForTx(Transaction miTx, boolean trace) throws Exception {
        boolean intr = false;
        try {
            boolean wasScheduled = false;
            TxLock txLock = null;
            Object deadlocker = miTx;
            if (deadlocker == null) {
                deadlocker = Thread.currentThread();
            }
            while (this.getTransaction() != null && !this.getTransaction().equals(miTx)) {
                try {
                    if (this.deadlockDetection) {
                        DeadlockDetector.singleton.deadlockDetection(deadlocker, (Resource)this);
                    }
                }
                catch (Exception e) {
                    if (txLock != null && txLock.isQueued) {
                        this.txLocks.remove(txLock);
                        this.txWaitQueue.remove(txLock);
                    }
                    throw e;
                }
                wasScheduled = true;
                if (this.lockMonitor != null) {
                    this.lockMonitor.contending();
                }
                if (trace) {
                    log.trace((Object)("Transactional contention on context" + this.id));
                }
                if (txLock == null) {
                    txLock = this.getTxLock(miTx);
                }
                if (trace) {
                    log.trace((Object)("Begin wait on Tx=" + this.getTransaction()));
                }
                TxLock txLock2 = txLock;
                synchronized (txLock2) {
                    this.releaseSync();
                    try {
                        txLock.wait(this.txTimeout);
                    }
                    catch (InterruptedException ignored) {
                        intr = true;
                    }
                }
                this.sync();
                if (trace) {
                    log.trace((Object)("End wait on TxLock=" + this.getTransaction()));
                }
                if (!this.isTxExpired(miTx)) continue;
                log.error((Object)(Thread.currentThread() + "Saw rolled back tx=" + miTx + " waiting for txLock"));
                if (txLock.isQueued) {
                    this.txLocks.remove(txLock);
                    this.txWaitQueue.remove(txLock);
                } else if (this.getTransaction() != null && this.getTransaction().equals(miTx)) {
                    this.nextTransaction();
                }
                if (miTx != null && this.deadlockDetection) {
                    DeadlockDetector.singleton.removeWaiting(deadlocker);
                }
                throw new RuntimeException("Transaction marked for rollback, possibly a timeout");
            }
            if (!wasScheduled) {
                this.setTransaction(miTx);
            }
            boolean bl = wasScheduled;
            return bl;
        }
        finally {
            if (intr) {
                Thread.currentThread().interrupt();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void nextTransaction() {
        if (this.synched == null) {
            throw new IllegalStateException("do not call nextTransaction while not synched!");
        }
        this.setTransaction(null);
        if (!this.txWaitQueue.isEmpty()) {
            TxLock thelock = (TxLock)this.txWaitQueue.removeFirst();
            this.txLocks.remove(thelock);
            thelock.isQueued = false;
            this.setTransaction(thelock.waitingTx);
            if (this.deadlockDetection) {
                DeadlockDetector.singleton.removeWaiting(thelock.deadlocker);
            }
            TxLock txLock = thelock;
            synchronized (txLock) {
                thelock.notifyAll();
            }
        }
    }

    public void endTransaction(Transaction transaction) {
        this.nextTransaction();
    }

    public void wontSynchronize(Transaction trasaction) {
        this.nextTransaction();
    }

    public void endInvocation(Invocation mi) {
        EntityEnterpriseContext ctx;
        Transaction tx = mi.getTransaction();
        if (tx != null && tx.equals(this.getTransaction()) && ((ctx = (EntityEnterpriseContext)mi.getEnterpriseContext()) == null || !ctx.hasTxSynchronization())) {
            this.endTransaction(tx);
        }
    }

    public void removeRef() {
        --this.refs;
        if (this.refs == 0 && this.txWaitQueue.size() > 0) {
            log.error((Object)("removing bean lock and it has tx's in QUEUE! " + this.toString()));
            throw new IllegalStateException("removing bean lock and it has tx's in QUEUE!");
        }
        if (this.refs == 0 && this.getTransaction() != null) {
            log.error((Object)("removing bean lock and it has tx set! " + this.toString()));
            throw new IllegalStateException("removing bean lock and it has tx set!");
        }
        if (this.refs < 0) {
            log.error((Object)"negative lock reference count should never happen !");
            throw new IllegalStateException("negative lock reference count !");
        }
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(100);
        buffer.append(super.toString());
        buffer.append(", bean=").append(this.container.getBeanMetaData().getEjbName());
        buffer.append(", id=").append(this.id);
        buffer.append(", refs=").append(this.refs);
        buffer.append(", tx=").append(this.getTransaction());
        buffer.append(", synched=").append(this.synched);
        buffer.append(", timeout=").append(this.txTimeout);
        buffer.append(", queue=").append(new ArrayList(this.txWaitQueue));
        return buffer.toString();
    }

    private class TxLock {
        public Transaction waitingTx = null;
        public int id = 0;
        public String threadName = Thread.currentThread().toString();
        public boolean isQueued;
        public Object deadlocker;

        public TxLock(Transaction trans) {
            this.waitingTx = trans;
            if (trans == null) {
                if (QueuedPessimisticEJBLock.this.txIdGen < 0) {
                    QueuedPessimisticEJBLock.this.txIdGen = 0;
                }
                this.id = QueuedPessimisticEJBLock.this.txIdGen++;
                this.deadlocker = Thread.currentThread();
            } else {
                this.deadlocker = trans;
            }
            this.isQueued = true;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            TxLock lock = (TxLock)obj;
            if (lock.waitingTx == null && this.waitingTx == null) {
                return lock.id == this.id;
            }
            if (lock.waitingTx != null && this.waitingTx != null) {
                return lock.waitingTx.equals(this.waitingTx);
            }
            return false;
        }

        public int hashCode() {
            return this.id;
        }

        public String toString() {
            StringBuffer buffer = new StringBuffer(100);
            buffer.append("TXLOCK waitingTx=").append(this.waitingTx);
            buffer.append(" id=").append(this.id);
            buffer.append(" thread=").append(this.threadName);
            buffer.append(" queued=").append(this.isQueued);
            return buffer.toString();
        }
    }
}

