/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jms;

import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.JMSException;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.TopicConnection;
import javax.jms.TopicConnectionFactory;
import javax.jms.XAConnection;
import javax.jms.XAConnectionFactory;
import javax.jms.XAQueueConnection;
import javax.jms.XAQueueConnectionFactory;
import javax.jms.XATopicConnection;
import javax.jms.XATopicConnectionFactory;
import org.jboss.logging.Logger;

public class ConnectionFactoryHelper {
    private static Logger log = Logger.getLogger(ConnectionFactoryHelper.class);

    public static Connection createConnection(Object factory, String username, String password) throws JMSException {
        XAConnection connection;
        if (factory == null) {
            throw new IllegalArgumentException("factory is null");
        }
        log.debug((Object)("using connection factory: " + factory));
        log.debug((Object)("using username/password: " + String.valueOf(username) + "/-- not shown --"));
        if (factory instanceof XAConnectionFactory) {
            XAConnectionFactory qFactory = (XAConnectionFactory)factory;
            connection = username != null ? qFactory.createXAConnection(username, password) : qFactory.createXAConnection();
            log.debug((Object)("created XAConnection: " + connection));
        } else if (factory instanceof ConnectionFactory) {
            ConnectionFactory qFactory = (ConnectionFactory)factory;
            connection = username != null ? qFactory.createConnection(username, password) : qFactory.createConnection();
            log.debug((Object)("created Connection: " + connection));
        } else {
            throw new IllegalArgumentException("factory is invalid");
        }
        return connection;
    }

    public static Connection createConnection(Object factory) throws JMSException {
        return ConnectionFactoryHelper.createConnection(factory, null, null);
    }

    public static QueueConnection createQueueConnection(Object factory, String username, String password) throws JMSException {
        XAQueueConnection connection;
        if (factory == null) {
            throw new IllegalArgumentException("factory is null");
        }
        log.debug((Object)("using connection factory: " + factory));
        log.debug((Object)("using username/password: " + String.valueOf(username) + "/-- not shown --"));
        if (factory instanceof XAQueueConnectionFactory) {
            XAQueueConnectionFactory qFactory = (XAQueueConnectionFactory)factory;
            connection = username != null ? qFactory.createXAQueueConnection(username, password) : qFactory.createXAQueueConnection();
            log.debug((Object)("created XAQueueConnection: " + connection));
        } else if (factory instanceof QueueConnectionFactory) {
            QueueConnectionFactory qFactory = (QueueConnectionFactory)factory;
            connection = username != null ? qFactory.createQueueConnection(username, password) : qFactory.createQueueConnection();
            log.debug((Object)("created QueueConnection: " + connection));
        } else {
            throw new IllegalArgumentException("factory is invalid");
        }
        return connection;
    }

    public static QueueConnection createQueueConnection(Object factory) throws JMSException {
        return ConnectionFactoryHelper.createQueueConnection(factory, null, null);
    }

    public static TopicConnection createTopicConnection(Object factory, String username, String password) throws JMSException {
        XATopicConnection connection;
        if (factory == null) {
            throw new IllegalArgumentException("factory is null");
        }
        log.debug((Object)("using connection factory: " + factory));
        log.debug((Object)("using username/password: " + String.valueOf(username) + "/-- not shown --"));
        if (factory instanceof XATopicConnectionFactory) {
            XATopicConnectionFactory tFactory = (XATopicConnectionFactory)factory;
            connection = username != null ? tFactory.createXATopicConnection(username, password) : tFactory.createXATopicConnection();
            log.debug((Object)("created XATopicConnection: " + connection));
        } else if (factory instanceof TopicConnectionFactory) {
            TopicConnectionFactory tFactory = (TopicConnectionFactory)factory;
            connection = username != null ? tFactory.createTopicConnection(username, password) : tFactory.createTopicConnection();
            log.debug((Object)("created TopicConnection: " + connection));
        } else {
            throw new IllegalArgumentException("factory is invalid");
        }
        return connection;
    }

    public static TopicConnection createTopicConnection(Object factory) throws JMSException {
        return ConnectionFactoryHelper.createTopicConnection(factory, null, null);
    }
}

