/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.el.convert;

import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.PropertyNotWritableException;
import javax.el.ValueExpression;
import javax.faces.component.StateHolder;
import javax.faces.context.FacesContext;
import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.shared_impl.util.ClassUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueBindingToValueExpression
extends ValueExpression
implements StateHolder {
    private static final long serialVersionUID = 8071429285360496554L;
    private static final Logger logger = Logger.getLogger(ValueBindingToValueExpression.class.getName());
    private ValueBinding _valueBinding;
    private boolean _transient;

    public ValueBindingToValueExpression() {
    }

    private ValueBinding getNotNullValueBinding() {
        if (this._valueBinding == null) {
            throw new IllegalStateException("value binding is null");
        }
        return this._valueBinding;
    }

    public ValueBindingToValueExpression(ValueBinding valueBinding) {
        if (valueBinding == null) {
            throw new IllegalArgumentException("value binding must not be null");
        }
        this._valueBinding = valueBinding;
    }

    public ValueBinding getValueBinding() {
        return this._valueBinding;
    }

    public boolean isReadOnly(final ELContext context) throws NullPointerException, javax.el.PropertyNotFoundException, ELException {
        return this.invoke(new Invoker<Boolean>(){

            @Override
            public Boolean invoke() {
                return ValueBindingToValueExpression.this.getNotNullValueBinding().isReadOnly(ValueBindingToValueExpression.this.getFacesContext(context));
            }
        });
    }

    public Object getValue(final ELContext context) throws NullPointerException, javax.el.PropertyNotFoundException, ELException {
        return this.invoke(new Invoker<Object>(){

            @Override
            public Object invoke() {
                return ValueBindingToValueExpression.this.getNotNullValueBinding().getValue(ValueBindingToValueExpression.this.getFacesContext(context));
            }
        });
    }

    public Class<?> getType(final ELContext context) throws NullPointerException, javax.el.PropertyNotFoundException, ELException {
        return (Class)this.invoke(new Invoker<Class<?>>(){

            @Override
            public Class<?> invoke() {
                return ValueBindingToValueExpression.this.getNotNullValueBinding().getType(ValueBindingToValueExpression.this.getFacesContext(context));
            }
        });
    }

    public void setValue(final ELContext context, final Object value) throws NullPointerException, javax.el.PropertyNotFoundException, PropertyNotWritableException, ELException {
        this.invoke(new Invoker<Object>(){

            @Override
            public Object invoke() {
                ValueBindingToValueExpression.this.getNotNullValueBinding().setValue(ValueBindingToValueExpression.this.getFacesContext(context), value);
                return null;
            }
        });
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this._transient ? 1231 : 1237);
        result = 31 * result + (this._valueBinding == null ? 0 : this._valueBinding.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        ValueBindingToValueExpression other = (ValueBindingToValueExpression)((Object)obj);
        if (this._transient != other._transient) {
            return false;
        }
        return !(this._valueBinding == null ? other._valueBinding != null : !this._valueBinding.equals(other._valueBinding));
    }

    public boolean isLiteralText() {
        return false;
    }

    public String getExpressionString() {
        return this.getNotNullValueBinding().getExpressionString();
    }

    public Class<?> getExpectedType() {
        if (this._valueBinding != null) {
            try {
                Object value = this.getNotNullValueBinding().getValue(FacesContext.getCurrentInstance());
                if (value != null) {
                    return value.getClass();
                }
            }
            catch (Throwable e) {
                logger.log(Level.WARNING, "Could not determine expected type for '" + this._valueBinding.getExpressionString() + "': " + e.getMessage(), e);
            }
        }
        return null;
    }

    public void restoreState(FacesContext context, Object state) {
        if (state instanceof ValueBinding) {
            this._valueBinding = (ValueBinding)state;
        } else if (state != null) {
            Object[] stateArray = (Object[])state;
            this._valueBinding = (ValueBinding)ClassUtils.newInstance((String)stateArray[0], ValueBinding.class);
            ((StateHolder)this._valueBinding).restoreState(context, stateArray[1]);
        }
    }

    public Object saveState(FacesContext context) {
        if (!this._transient) {
            if (this._valueBinding instanceof StateHolder) {
                Object[] state = new Object[]{this._valueBinding.getClass().getName(), ((StateHolder)this._valueBinding).saveState(context)};
                return state;
            }
            return this._valueBinding;
        }
        return null;
    }

    public void setTransient(boolean newTransientValue) {
        this._transient = newTransientValue;
    }

    public boolean isTransient() {
        return this._transient;
    }

    private FacesContext getFacesContext(ELContext context) {
        if (context == null) {
            throw new IllegalArgumentException("el context must not be null.");
        }
        FacesContext facesContext = (FacesContext)context.getContext(FacesContext.class);
        if (facesContext == null) {
            throw new IllegalStateException("faces context not available in el context.");
        }
        return facesContext;
    }

    private <T> T invoke(Invoker<T> invoker) {
        try {
            return invoker.invoke();
        }
        catch (PropertyNotFoundException e) {
            throw new javax.el.PropertyNotFoundException(e.getMessage(), (Throwable)e);
        }
        catch (EvaluationException e) {
            throw new ELException(e.getMessage(), (Throwable)e);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static interface Invoker<T> {
        public T invoke();
    }
}

