/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.util;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.util.AddressAdapter;
import org.hibernate.cache.infinispan.util.AddressAdapterImpl;
import org.hibernate.cache.infinispan.util.CacheAdapter;
import org.hibernate.cache.infinispan.util.FlagAdapter;
import org.infinispan.Cache;
import org.infinispan.config.Configuration;
import org.infinispan.context.Flag;
import org.infinispan.remoting.rpc.RpcManager;
import org.infinispan.util.concurrent.TimeoutException;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

public class CacheAdapterImpl
implements CacheAdapter {
    private static final Log log = LogFactory.getLog(CacheAdapterImpl.class);
    private final Cache cache;

    private CacheAdapterImpl(Cache cache) {
        this.cache = cache;
    }

    public static CacheAdapter newInstance(Cache cache) {
        return new CacheAdapterImpl(cache);
    }

    @Override
    public boolean isClusteredInvalidation() {
        return CacheAdapterImpl.isClusteredInvalidation(this.cache.getConfiguration().getCacheMode());
    }

    @Override
    public boolean isClusteredReplication() {
        return CacheAdapterImpl.isClusteredReplication(this.cache.getConfiguration().getCacheMode());
    }

    @Override
    public boolean isSynchronous() {
        return CacheAdapterImpl.isSynchronous(this.cache.getConfiguration().getCacheMode());
    }

    @Override
    public Set keySet() {
        return this.cache.keySet();
    }

    @Override
    public CacheAdapter withFlags(FlagAdapter ... flagAdapters) {
        Flag[] flags = FlagAdapter.toFlags(flagAdapters);
        return CacheAdapterImpl.newInstance((Cache)this.cache.getAdvancedCache().withFlags(flags));
    }

    @Override
    public Object get(Object key) throws CacheException {
        try {
            return this.cache.get(key);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public Object getAllowingTimeout(Object key) throws CacheException {
        try {
            return this.getFailSilentCache().get(key);
        }
        catch (TimeoutException ignored) {
            return null;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public Object put(Object key, Object value) throws CacheException {
        try {
            return this.cache.put(key, value);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public Object putAllowingTimeout(Object key, Object value) throws CacheException {
        try {
            return this.getFailSilentCache().put(key, value);
        }
        catch (TimeoutException allowed) {
            return null;
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public void putForExternalRead(Object key, Object value) throws CacheException {
        try {
            this.cache.putForExternalRead(key, value);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public Object remove(Object key) throws CacheException {
        try {
            return this.cache.remove(key);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public void evict(Object key) throws CacheException {
        try {
            this.cache.evict(key);
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public void clear() throws CacheException {
        try {
            this.cache.clear();
        }
        catch (Exception e) {
            throw new CacheException((Throwable)e);
        }
    }

    @Override
    public void stop() {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Stop " + this.cache));
        }
        this.cache.stop();
    }

    private static boolean isClusteredInvalidation(Configuration.CacheMode cacheMode) {
        return cacheMode == Configuration.CacheMode.INVALIDATION_ASYNC || cacheMode == Configuration.CacheMode.INVALIDATION_SYNC;
    }

    private static boolean isClusteredReplication(Configuration.CacheMode cacheMode) {
        return cacheMode == Configuration.CacheMode.REPL_ASYNC || cacheMode == Configuration.CacheMode.REPL_SYNC;
    }

    private static boolean isSynchronous(Configuration.CacheMode cacheMode) {
        return cacheMode == Configuration.CacheMode.REPL_SYNC || cacheMode == Configuration.CacheMode.INVALIDATION_SYNC || cacheMode == Configuration.CacheMode.DIST_SYNC;
    }

    @Override
    public void addListener(Object listener) {
        this.cache.addListener(listener);
    }

    @Override
    public AddressAdapter getAddress() {
        RpcManager rpc = this.cache.getAdvancedCache().getRpcManager();
        if (rpc != null) {
            return AddressAdapterImpl.newInstance(rpc.getTransport().getAddress());
        }
        return null;
    }

    @Override
    public List<AddressAdapter> getMembers() {
        RpcManager rpc = this.cache.getAdvancedCache().getRpcManager();
        if (rpc != null) {
            return AddressAdapterImpl.toAddressAdapter(rpc.getTransport().getMembers());
        }
        return null;
    }

    public RpcManager getRpcManager() {
        return this.cache.getAdvancedCache().getRpcManager();
    }

    @Override
    public int size() {
        return this.cache.size();
    }

    @Override
    public Map toMap() {
        return this.cache;
    }

    @Override
    public void removeListener(Object listener) {
        this.cache.removeListener(listener);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.cache.containsKey(key);
    }

    @Override
    public Configuration getConfiguration() {
        return this.cache.getConfiguration();
    }

    private Cache getFailSilentCache() {
        return this.cache.getAdvancedCache().withFlags(new Flag[]{Flag.FAIL_SILENTLY});
    }
}

