/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.webservices.integration.deployers;

import java.util.HashMap;
import java.util.Map;
import org.jboss.deployers.plugins.deployers.DeployersImpl;
import org.jboss.deployers.spi.deployer.Deployer;
import org.jboss.logging.Logger;
import org.jboss.webservices.integration.deployers.WSDeploymentAspectDeployer;
import org.jboss.wsf.spi.deployment.DeploymentAspect;

public final class WSAspectizedDeployersFactory {
    private static final Logger LOGGER = Logger.getLogger(WSAspectizedDeployersFactory.class);
    private final DeployersImpl delegee;
    private final Map<DeploymentAspect, Deployer> deployersRegistry = new HashMap<DeploymentAspect, Deployer>();

    public WSAspectizedDeployersFactory(DeployersImpl realDeployers) {
        this.delegee = realDeployers;
    }

    public void addDeployer(DeploymentAspect aspect) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Adding deployer for: " + aspect));
        }
        WSDeploymentAspectDeployer wsAspectizedDeployer = new WSDeploymentAspectDeployer(aspect);
        this.delegee.addDeployer((Deployer)wsAspectizedDeployer);
        this.deployersRegistry.put(aspect, (Deployer)wsAspectizedDeployer);
    }

    public void removeDeployer(DeploymentAspect aspect) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace((Object)("Removing deployer for: " + aspect));
        }
        Deployer wsAspectizedDeployer = this.deployersRegistry.get(aspect);
        this.deployersRegistry.remove(aspect);
        this.delegee.removeDeployer(wsAspectizedDeployer);
    }
}

