/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.Address;
import org.apache.juddi.datatype.AddressLine;
import org.apache.juddi.datatype.Description;
import org.apache.juddi.datatype.Email;
import org.apache.juddi.datatype.PersonName;
import org.apache.juddi.datatype.Phone;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.business.Contact;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class ContactHandler
extends AbstractHandler {
    public static final String TAG_NAME = "contact";
    private HandlerMaker maker = null;

    protected ContactHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        int i;
        Contact obj = new Contact();
        Vector nodeList = null;
        AbstractHandler handler = null;
        String useType = element.getAttribute("useType");
        if (useType != null && useType.trim().length() > 0) {
            obj.setUseType(useType);
        }
        if ((nodeList = XMLUtils.getChildElementsByTagName(element, "personName")).size() > 0) {
            handler = this.maker.lookup("personName");
            obj.setPersonName((PersonName)handler.unmarshal((Element)nodeList.elementAt(0)));
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "description");
        for (i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("description");
            Description descr = (Description)handler.unmarshal((Element)nodeList.elementAt(i));
            if (descr == null) continue;
            obj.addDescription(descr);
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "address");
        for (i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("address");
            obj.addAddress((Address)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "email");
        for (i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("email");
            obj.addEmail((Email)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "phone");
        for (i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("phone");
            obj.addPhone((Phone)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        Vector addressVector;
        Vector emailVector;
        Vector phoneVector;
        PersonName personName;
        Vector descrVector;
        Contact contact = (Contact)object;
        Element element = parent.getOwnerDocument().createElementNS(null, TAG_NAME);
        AbstractHandler handler = null;
        String useType = contact.getUseType();
        if (useType != null && useType.trim().length() > 0) {
            element.setAttribute("useType", useType);
        }
        if ((descrVector = contact.getDescriptionVector()) != null && descrVector.size() > 0) {
            handler = this.maker.lookup("description");
            for (int i = 0; i < descrVector.size(); ++i) {
                handler.marshal((Description)descrVector.elementAt(i), element);
            }
        }
        if ((personName = contact.getPersonName()) != null) {
            handler = this.maker.lookup("personName");
            handler.marshal(personName, element);
        }
        if ((phoneVector = contact.getPhoneVector()) != null && phoneVector.size() > 0) {
            handler = this.maker.lookup("phone");
            for (int i = 0; i < phoneVector.size(); ++i) {
                handler.marshal((Phone)phoneVector.elementAt(i), element);
            }
        }
        if ((emailVector = contact.getEmailVector()) != null && emailVector.size() > 0) {
            handler = this.maker.lookup("email");
            for (int i = 0; i < emailVector.size(); ++i) {
                handler.marshal((Email)emailVector.elementAt(i), element);
            }
        }
        if ((addressVector = contact.getAddressVector()) != null && addressVector.size() > 0) {
            handler = this.maker.lookup("address");
            for (int i = 0; i < addressVector.size(); ++i) {
                handler.marshal((Address)addressVector.elementAt(i), element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        Address address = new Address();
        address.setUseType("myAddressUseType");
        address.setSortCode("sortThis");
        address.setTModelKey(null);
        address.addAddressLine(new AddressLine("AddressLine1", "keyNameAttr", "keyValueAttr"));
        address.addAddressLine(new AddressLine("AddressLine2"));
        Contact contact = new Contact();
        contact.setPersonNameValue("Bob Whatever");
        contact.addDescription(new Description("Bob is a big fat jerk"));
        contact.addDescription(new Description("obBay sIay a igBay atFay erkJay", "es"));
        contact.addEmail(new Email("bob@whatever.com"));
        contact.addPhone(new Phone("(603)559-1901"));
        contact.addAddress(address);
        System.out.println();
        RegistryObject regObject = contact;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
    }
}

