/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juddi.handler;

import java.util.Vector;
import org.apache.juddi.datatype.RegistryObject;
import org.apache.juddi.datatype.business.BusinessEntity;
import org.apache.juddi.datatype.request.ValidateValues;
import org.apache.juddi.datatype.service.BusinessService;
import org.apache.juddi.datatype.tmodel.TModel;
import org.apache.juddi.handler.AbstractHandler;
import org.apache.juddi.handler.HandlerMaker;
import org.apache.juddi.util.xml.XMLUtils;
import org.w3c.dom.Element;

public class ValidateValuesHandler
extends AbstractHandler {
    public static final String TAG_NAME = "validate_values";
    private HandlerMaker maker = null;

    protected ValidateValuesHandler(HandlerMaker maker) {
        this.maker = maker;
    }

    public RegistryObject unmarshal(Element element) {
        int i;
        ValidateValues obj = new ValidateValues();
        Vector nodeList = null;
        AbstractHandler handler = null;
        String generic = element.getAttribute("generic");
        if (generic != null && generic.trim().length() > 0) {
            obj.setGeneric(generic);
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "businessEntity");
        for (i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("businessEntity");
            obj.addBusinessEntity((BusinessEntity)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "businessService");
        for (i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("businessService");
            obj.addBusinessService((BusinessService)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        nodeList = XMLUtils.getChildElementsByTagName(element, "tModel");
        for (i = 0; i < nodeList.size(); ++i) {
            handler = this.maker.lookup("tModel");
            obj.addTModel((TModel)handler.unmarshal((Element)nodeList.elementAt(i)));
        }
        return obj;
    }

    public void marshal(RegistryObject object, Element parent) {
        Vector tModelVector;
        Vector serviceVector;
        Vector businessVector;
        ValidateValues request = (ValidateValues)object;
        Element element = parent.getOwnerDocument().createElementNS(null, TAG_NAME);
        AbstractHandler handler = null;
        String generic = request.getGeneric();
        if (generic != null) {
            element.setAttribute("generic", generic);
        }
        if ((businessVector = request.getBusinessEntityVector()) != null && businessVector.size() > 0) {
            handler = this.maker.lookup("businessEntity");
            for (int i = 0; i < businessVector.size(); ++i) {
                handler.marshal((BusinessEntity)businessVector.elementAt(i), element);
            }
        }
        if ((serviceVector = request.getBusinessServiceVector()) != null && serviceVector.size() > 0) {
            handler = this.maker.lookup("businessService");
            for (int i = 0; i < serviceVector.size(); ++i) {
                handler.marshal((BusinessService)serviceVector.elementAt(i), element);
            }
        }
        if ((tModelVector = request.getTModelVector()) != null && tModelVector.size() > 0) {
            handler = this.maker.lookup("tModel");
            for (int i = 0; i < tModelVector.size(); ++i) {
                handler.marshal((TModel)tModelVector.elementAt(i), element);
            }
        }
        parent.appendChild(element);
    }

    public static void main(String[] args) throws Exception {
        HandlerMaker maker = HandlerMaker.getInstance();
        AbstractHandler handler = maker.lookup(TAG_NAME);
        Element parent = XMLUtils.newRootElement();
        Element child = null;
        BusinessEntity business = new BusinessEntity();
        BusinessService service = new BusinessService();
        TModel tModel = new TModel();
        ValidateValues request = new ValidateValues();
        request.addBusinessEntity(business);
        request.addBusinessService(service);
        request.addTModel(tModel);
        System.out.println();
        RegistryObject regObject = request;
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
        regObject = handler.unmarshal(child);
        handler.marshal(regObject, parent);
        child = (Element)parent.getFirstChild();
        parent.removeChild(child);
        XMLUtils.writeXML(child, System.out);
        System.out.println();
    }
}

