/*
 * Decompiled with CFR 0.152.
 */
package org.hornetq.core.protocol.core.impl.wireformat;

import org.hornetq.api.core.HornetQBuffer;
import org.hornetq.core.protocol.core.impl.PacketImpl;

public class Ping
extends PacketImpl {
    private long connectionTTL;

    public Ping(long connectionTTL) {
        super((byte)10);
        this.connectionTTL = connectionTTL;
    }

    public Ping() {
        super((byte)10);
    }

    public long getConnectionTTL() {
        return this.connectionTTL;
    }

    @Override
    public void encodeRest(HornetQBuffer buffer) {
        buffer.writeLong(this.connectionTTL);
    }

    @Override
    public void decodeRest(HornetQBuffer buffer) {
        this.connectionTTL = buffer.readLong();
    }

    @Override
    public String toString() {
        StringBuffer buf = new StringBuffer(this.getParentString());
        buf.append(", connectionTTL=" + this.connectionTTL);
        buf.append("]");
        return buf.toString();
    }

    @Override
    public boolean equals(Object other) {
        if (!(other instanceof Ping)) {
            return false;
        }
        Ping r = (Ping)other;
        return super.equals(other) && this.connectionTTL == r.connectionTTL;
    }

    @Override
    public final boolean isRequiresConfirmations() {
        return false;
    }
}

