/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.jboss.logging.Logger;

public final class IntrospectionUtils {
    private static Logger log = Logger.getLogger(IntrospectionUtils.class);
    static final int dbg = 0;

    public static boolean setProperty(Object o, String name, String value) {
        String setter = "set" + IntrospectionUtils.capitalize(name);
        try {
            int i;
            Method[] methods = o.getClass().getMethods();
            Method setPropertyMethodVoid = null;
            Method setPropertyMethodBool = null;
            for (i = 0; i < methods.length; ++i) {
                Class<?>[] paramT = methods[i].getParameterTypes();
                if (!setter.equals(methods[i].getName()) || paramT.length != 1 || !"java.lang.String".equals(paramT[0].getName())) continue;
                methods[i].invoke(o, value);
                return true;
            }
            for (i = 0; i < methods.length; ++i) {
                boolean ok = true;
                if (setter.equals(methods[i].getName()) && methods[i].getParameterTypes().length == 1) {
                    Class<?> paramType = methods[i].getParameterTypes()[0];
                    Object[] params = new Object[1];
                    if ("java.lang.Integer".equals(paramType.getName()) || "int".equals(paramType.getName())) {
                        try {
                            params[0] = new Integer(value);
                        }
                        catch (NumberFormatException ex) {
                            ok = false;
                        }
                    } else if ("java.lang.Long".equals(paramType.getName()) || "long".equals(paramType.getName())) {
                        try {
                            params[0] = new Long(value);
                        }
                        catch (NumberFormatException ex) {
                            ok = false;
                        }
                    } else if ("java.lang.Boolean".equals(paramType.getName()) || "boolean".equals(paramType.getName())) {
                        params[0] = new Boolean(value);
                    } else if ("java.net.InetAddress".equals(paramType.getName())) {
                        try {
                            params[0] = InetAddress.getByName(value);
                        }
                        catch (UnknownHostException exc) {
                            IntrospectionUtils.d("Unable to resolve host name:" + value);
                            ok = false;
                        }
                    } else {
                        IntrospectionUtils.d("Unknown type " + paramType.getName());
                    }
                    if (ok) {
                        methods[i].invoke(o, params);
                        return true;
                    }
                }
                if (!"setProperty".equals(methods[i].getName())) continue;
                if (methods[i].getReturnType() == Boolean.TYPE) {
                    setPropertyMethodBool = methods[i];
                    continue;
                }
                setPropertyMethodVoid = methods[i];
            }
            if (setPropertyMethodBool != null || setPropertyMethodVoid != null) {
                Object[] params = new Object[]{name, value};
                if (setPropertyMethodBool != null) {
                    return (Boolean)setPropertyMethodBool.invoke(o, params);
                }
                setPropertyMethodVoid.invoke(o, params);
                return true;
            }
        }
        catch (IllegalArgumentException ex2) {
            log.warn((Object)("IAE " + o + " " + name + " " + value), (Throwable)ex2);
        }
        catch (SecurityException ex1) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException ie) {
            // empty catch block
        }
        return false;
    }

    public static Object getProperty(Object o, String name) {
        String getter = "get" + IntrospectionUtils.capitalize(name);
        String isGetter = "is" + IntrospectionUtils.capitalize(name);
        try {
            Method[] methods = o.getClass().getMethods();
            Method getPropertyMethod = null;
            for (int i = 0; i < methods.length; ++i) {
                Class<?>[] paramT = methods[i].getParameterTypes();
                if (getter.equals(methods[i].getName()) && paramT.length == 0) {
                    return methods[i].invoke(o, (Object[])null);
                }
                if (isGetter.equals(methods[i].getName()) && paramT.length == 0) {
                    return methods[i].invoke(o, (Object[])null);
                }
                if (!"getProperty".equals(methods[i].getName())) continue;
                getPropertyMethod = methods[i];
            }
            if (getPropertyMethod != null) {
                Object[] params = new Object[]{name};
                return getPropertyMethod.invoke(o, params);
            }
        }
        catch (IllegalArgumentException ex2) {
            log.warn((Object)("IAE " + o + " " + name), (Throwable)ex2);
        }
        catch (SecurityException ex1) {
        }
        catch (IllegalAccessException iae) {
        }
        catch (InvocationTargetException ie) {
            // empty catch block
        }
        return null;
    }

    public static Object callMethod1(Object target, String methodN, Object param1, String typeParam1, ClassLoader cl) throws Exception {
        if (target == null || param1 == null) {
            IntrospectionUtils.d("Assert: Illegal params " + target + " " + param1);
        }
        Class[] params = new Class[]{typeParam1 == null ? param1.getClass() : cl.loadClass(typeParam1)};
        Method m = IntrospectionUtils.findMethod(target.getClass(), methodN, params);
        if (m == null) {
            throw new NoSuchMethodException(target.getClass().getName() + " " + methodN);
        }
        return m.invoke(target, param1);
    }

    public static Method findMethod(Class c, String name, Class[] params) {
        Method[] methods = c.getMethods();
        if (methods == null) {
            return null;
        }
        for (int i = 0; i < methods.length; ++i) {
            if (!methods[i].getName().equals(name)) continue;
            Class<?>[] methodParams = methods[i].getParameterTypes();
            if (methodParams == null && (params == null || params.length == 0)) {
                return methods[i];
            }
            if (params == null && (methodParams == null || methodParams.length == 0)) {
                return methods[i];
            }
            if (params.length != methodParams.length) continue;
            boolean found = true;
            for (int j = 0; j < params.length; ++j) {
                if (params[j] == methodParams[j]) continue;
                found = false;
                break;
            }
            if (!found) continue;
            return methods[i];
        }
        return null;
    }

    public static String capitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toUpperCase(chars[0]);
        return new String(chars);
    }

    public static String unCapitalize(String name) {
        if (name == null || name.length() == 0) {
            return name;
        }
        char[] chars = name.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    static void d(String s) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("IntrospectionUtils: " + s));
        }
    }
}

