/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.marshalling;

import java.io.Flushable;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.jboss.marshalling.ByteOutput;

public class NioByteOutput
extends OutputStream
implements ByteOutput {
    private final Object lock = new Object();
    private ByteBuffer buffer;
    private boolean eof;
    private final BufferWriter bufferWriterTask;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NioByteOutput(BufferWriter bufferWriterTask) {
        this.bufferWriterTask = bufferWriterTask;
        Object object = this.lock;
        synchronized (object) {
            this.buffer = bufferWriterTask.getBuffer();
        }
    }

    private static IOException closed() {
        return new IOException("Stream is closed");
    }

    private void checkClosed() throws IOException {
        if (this.eof) {
            throw NioByteOutput.closed();
        }
    }

    private ByteBuffer getBuffer() throws IOException {
        ByteBuffer buffer = this.buffer;
        if (buffer != null && buffer.hasRemaining()) {
            return buffer;
        }
        if (buffer != null) {
            this.send();
        }
        this.buffer = this.bufferWriterTask.getBuffer();
        return this.buffer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(int b) throws IOException {
        NioByteOutput nioByteOutput = this;
        synchronized (nioByteOutput) {
            this.checkClosed();
            this.getBuffer().put((byte)b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        NioByteOutput nioByteOutput = this;
        synchronized (nioByteOutput) {
            this.checkClosed();
            while (len > 0) {
                ByteBuffer buffer = this.getBuffer();
                int cnt = Math.min(len, buffer.remaining());
                buffer.put(b, off, cnt);
                len -= cnt;
                off += cnt;
            }
        }
    }

    private void send() throws IOException {
        ByteBuffer buffer = this.buffer;
        this.buffer = null;
        boolean eof = this.eof;
        if (buffer != null && buffer.position() > 0) {
            buffer.flip();
            this.send(buffer, eof);
        } else if (eof) {
            ByteBuffer buffer1 = this.getBuffer();
            buffer1.flip();
            this.send(buffer1, eof);
        }
    }

    private void send(ByteBuffer buffer, boolean eof) throws IOException {
        try {
            this.bufferWriterTask.accept(buffer, eof);
        }
        catch (IOException e) {
            this.eof = true;
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() throws IOException {
        NioByteOutput nioByteOutput = this;
        synchronized (nioByteOutput) {
            this.send();
            try {
                this.bufferWriterTask.flush();
            }
            catch (IOException e) {
                this.eof = true;
                this.buffer = null;
                throw e;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        NioByteOutput nioByteOutput = this;
        synchronized (nioByteOutput) {
            if (this.eof) {
                return;
            }
            this.eof = true;
            this.flush();
        }
    }

    public static interface BufferWriter
    extends Flushable {
        public ByteBuffer getBuffer();

        public void accept(ByteBuffer var1, boolean var2) throws IOException;

        @Override
        public void flush() throws IOException;
    }
}

