/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.integration.deployers;

import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.Provider;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.DeploymentStages;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;
import org.jboss.logging.Logger;
import org.jboss.metadata.javaee.spec.ParamValueMetaData;
import org.jboss.metadata.web.jboss.JBossServletMetaData;
import org.jboss.metadata.web.jboss.JBossWebMetaData;
import org.jboss.metadata.web.spec.FilterMetaData;
import org.jboss.resteasy.integration.deployers.ResteasyDeploymentData;
import org.jboss.resteasy.integration.deployers.ResteasyIntegrationDeployer;
import org.jboss.resteasy.plugins.server.servlet.HttpServlet30Dispatcher;
import org.jboss.resteasy.plugins.server.servlet.ResteasyBootstrapClasses;
import org.jboss.scanning.annotations.spi.AnnotationIndex;
import org.jboss.scanning.annotations.spi.AnnotationRepository;
import org.jboss.scanning.annotations.spi.Element;
import org.jboss.scanning.hierarchy.spi.HierarchyIndex;

public class ResteasyScannerDeployer
extends AbstractRealDeployer {
    private static final Logger LOGGER = Logger.getLogger(ResteasyScannerDeployer.class);
    public static final Set<String> BOOT_CLASSES = new HashSet<String>();

    public ResteasyScannerDeployer() {
        this.addRequiredInput(JBossWebMetaData.class);
        this.addInput(AnnotationRepository.class);
        this.addOutput(JBossWebMetaData.class);
        this.addOutput(ResteasyDeploymentData.class);
        this.setStage(DeploymentStages.PRE_REAL);
    }

    protected void internalDeploy(DeploymentUnit du) throws DeploymentException {
        JBossWebMetaData webdata = (JBossWebMetaData)du.getAttachment(JBossWebMetaData.class);
        this.scan(du, webdata);
    }

    protected boolean hasBootClasses(DeploymentUnit du, JBossWebMetaData webdata) throws DeploymentException {
        if (webdata.getServlets() != null) {
            for (JBossServletMetaData servlet : webdata.getServlets()) {
                String servletClass = servlet.getServletClass();
                if (!BOOT_CLASSES.contains(servletClass)) continue;
                return true;
            }
        }
        if (webdata.getFilters() != null) {
            for (FilterMetaData filter : webdata.getFilters()) {
                if (!BOOT_CLASSES.contains(filter.getFilterClass())) continue;
                return true;
            }
        }
        return false;
    }

    protected void scan(DeploymentUnit du, JBossWebMetaData webdata) throws DeploymentException {
        AnnotationIndex env;
        List contextParams;
        ResteasyDeploymentData resteasyDeploymentData = new ResteasyDeploymentData();
        du.addAttachment(ResteasyDeploymentData.class, (Object)resteasyDeploymentData);
        boolean hasBoot = this.hasBootClasses(du, webdata);
        resteasyDeploymentData.setBootClasses(hasBoot);
        Class declaredApplicationClass = this.checkDeclaredApplicationClassAsServlet(du, webdata);
        if (declaredApplicationClass != null) {
            resteasyDeploymentData.setDispatcherCreated(true);
        }
        if (!hasBoot && !webdata.isMetadataComplete()) {
            resteasyDeploymentData.setScanAll(true);
            resteasyDeploymentData.setScanProviders(true);
            resteasyDeploymentData.setScanResources(true);
        }
        if ((contextParams = webdata.getContextParams()) != null) {
            for (ParamValueMetaData param : contextParams) {
                if (param.getParamName().equals("resteasy.scan")) {
                    resteasyDeploymentData.setScanAll(Boolean.valueOf(param.getParamValue()));
                    continue;
                }
                if (param.getParamName().equals("resteasy.scan.providers")) {
                    resteasyDeploymentData.setScanProviders(Boolean.valueOf(param.getParamValue()));
                    continue;
                }
                if (param.getParamName().equals("resteasy.scan.resources")) {
                    resteasyDeploymentData.setScanResources(Boolean.valueOf(param.getParamValue()));
                    continue;
                }
                if (!param.getParamName().equals("resteasy.unwrapped.exceptions")) continue;
                resteasyDeploymentData.setUnwrappedExceptionsParameterSet(true);
            }
        }
        if (!resteasyDeploymentData.shouldScan()) {
            return;
        }
        if (declaredApplicationClass == null) {
            HierarchyIndex hier = (HierarchyIndex)du.getAttachment(HierarchyIndex.class);
            if (hier != null) {
                Set applicationClass = hier.getSubClassesOf(null, Application.class);
                if (applicationClass != null) {
                    if (applicationClass.size() > 1) {
                        StringBuilder builder = new StringBuilder("Only one JAX-RS Application Class allowed.");
                        HashSet<Class> aClasses = new HashSet<Class>();
                        for (Class c : applicationClass) {
                            if (!c.isAnonymousClass() && !Modifier.isAbstract(c.getModifiers())) {
                                aClasses.add(c);
                            }
                            builder.append(" ").append(c.getName());
                        }
                        if (aClasses.size() > 1) {
                            throw new DeploymentException(builder.toString());
                        }
                        if (aClasses.size() == 1) {
                            Class aClass = (Class)applicationClass.iterator().next();
                            resteasyDeploymentData.setScannedApplicationClass(aClass);
                        }
                    } else if (applicationClass.size() == 1) {
                        Class aClass = (Class)applicationClass.iterator().next();
                        resteasyDeploymentData.setScannedApplicationClass(aClass);
                    }
                }
            } else {
                LOGGER.debug((Object)"Expecting HierarchyIndex class for scanning WAR for JAX-RS Application class");
            }
        }
        if ((env = (AnnotationIndex)du.getAttachment(AnnotationIndex.class)) == null) {
            LOGGER.debug((Object)"Expecting AnnotationRepository class for scanning WAR for JAX-RS classes");
            return;
        }
        Set resources = null;
        Set providers = null;
        if (resteasyDeploymentData.isScanResources()) {
            resources = env.classIsAnnotatedWith(Path.class);
        }
        if (resteasyDeploymentData.isScanProviders()) {
            providers = env.classIsAnnotatedWith(Provider.class);
        }
        if ((resources == null || resources.isEmpty()) && (providers == null || providers.isEmpty())) {
            return;
        }
        if (resources != null) {
            for (Element e : resources) {
                if (e.getOwner().isInterface()) continue;
                resteasyDeploymentData.getScannedResourceClasses().add(e.getOwnerClassName());
            }
        }
        if (providers != null) {
            for (Element e : providers) {
                if (e.getOwner().isInterface()) continue;
                resteasyDeploymentData.getScannedProviderClasses().add(e.getOwnerClassName());
            }
        }
        Set strings = env.classesImplementingInterfacesAnnotatedWith(Path.class.getName());
        resteasyDeploymentData.getScannedResourceClasses().addAll(strings);
    }

    protected Class checkDeclaredApplicationClassAsServlet(DeploymentUnit du, JBossWebMetaData webdata) throws DeploymentException {
        ClassLoader loader = du.getClassLoader();
        if (webdata.getServlets() == null) {
            return null;
        }
        for (JBossServletMetaData servlet : webdata.getServlets()) {
            String servletClass = servlet.getServletClass();
            if (servletClass == null) continue;
            Class<?> clazz = null;
            try {
                clazz = loader.loadClass(servletClass);
            }
            catch (ClassNotFoundException e) {
                throw new DeploymentException((Throwable)e);
            }
            if (!Application.class.isAssignableFrom(clazz)) continue;
            servlet.setServletClass(HttpServlet30Dispatcher.class.getName());
            servlet.setAsyncSupported(true);
            ParamValueMetaData param = new ParamValueMetaData();
            param.setParamName("javax.ws.rs.Application");
            param.setParamValue(servletClass);
            ArrayList<ParamValueMetaData> params = servlet.getInitParam();
            if (params == null) {
                params = new ArrayList<ParamValueMetaData>();
                servlet.setInitParam(params);
            }
            params.add(param);
            try {
                Thread.currentThread().getContextClassLoader().loadClass("org.jboss.resteasy.cdi.CdiInjectorFactory");
                if (((VFSDeploymentUnit)du).getMetaDataFile("beans.xml") != null) {
                    ResteasyIntegrationDeployer.setContextParameter(webdata, "resteasy.injector.factory", "org.jboss.resteasy.cdi.CdiInjectorFactory");
                }
            }
            catch (ClassNotFoundException ignored) {
                // empty catch block
            }
            return clazz;
        }
        return null;
    }

    static {
        for (String clazz : ResteasyBootstrapClasses.BOOTSTRAP_CLASSES) {
            BOOT_CLASSES.add(clazz);
        }
    }
}

