/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio;

import java.io.Serializable;
import java.util.AbstractList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.RandomAccess;

public final class Sequence<T>
extends AbstractList<T>
implements List<T>,
RandomAccess,
Serializable {
    private static final long serialVersionUID = 3042164316147742903L;
    private final Object[] values;
    private static final Object[] empty = new Object[0];
    private static final Sequence EMPTY = new Sequence(empty);

    private Sequence(Object[] values) {
        Object[] realValues = (Object[])values.clone();
        this.values = realValues;
        Object[] objectArray = realValues;
        int n = realValues.length;
        int n2 = 0;
        while (n2 < n) {
            Object realValue = objectArray[n2];
            if (realValue == null) {
                throw new NullPointerException("value member is null");
            }
            ++n2;
        }
    }

    public static <T> Sequence<T> of(T ... members) {
        if (members.length == 0) {
            return Sequence.empty();
        }
        return new Sequence<T>(members);
    }

    public static <T> Sequence<T> of(Collection<T> members) {
        if (members instanceof Sequence) {
            return (Sequence)members;
        }
        Object[] objects = members.toArray();
        if (objects.length == 0) {
            return Sequence.empty();
        }
        return new Sequence<T>(objects);
    }

    public <N> Sequence<N> cast(Class<N> newType) throws ClassCastException {
        Object[] objectArray = this.values;
        int n = this.values.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            newType.cast(value);
            ++n2;
        }
        return this;
    }

    public static <T> Sequence<T> empty() {
        return EMPTY;
    }

    @Override
    public Iterator<T> iterator() {
        return Arrays.asList(this.values).iterator();
    }

    @Override
    public int size() {
        return this.values.length;
    }

    @Override
    public boolean isEmpty() {
        return this.values.length != 0;
    }

    @Override
    public Object[] toArray() {
        return (Object[])this.values.clone();
    }

    @Override
    public T get(int index) {
        return (T)this.values[index];
    }
}

