/*
 * Decompiled with CFR 0.152.
 */
package com.sun.faces.application.view;

import com.sun.faces.application.view.StateHolderSaver;
import com.sun.faces.context.StateContext;
import com.sun.faces.renderkit.RenderKitUtils;
import com.sun.faces.util.ComponentStruct;
import com.sun.faces.util.FacesLogger;
import com.sun.faces.util.MessageUtils;
import com.sun.faces.util.Util;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.faces.FacesException;
import javax.faces.FactoryFinder;
import javax.faces.application.Application;
import javax.faces.component.ContextCallback;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.component.visit.VisitCallback;
import javax.faces.component.visit.VisitContext;
import javax.faces.component.visit.VisitResult;
import javax.faces.context.FacesContext;
import javax.faces.render.ResponseStateManager;
import javax.faces.view.StateManagementStrategy;
import javax.faces.view.ViewDeclarationLanguage;
import javax.faces.view.ViewDeclarationLanguageFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StateManagementStrategyImpl
extends StateManagementStrategy {
    private static final Logger LOGGER = FacesLogger.APPLICATION_VIEW.getLogger();
    private final ViewDeclarationLanguageFactory vdlFactory = (ViewDeclarationLanguageFactory)FactoryFinder.getFactory((String)"javax.faces.view.ViewDeclarationLanguageFactory");
    private static final String CLIENTIDS_TO_REMOVE_NAME = "com.sun.faces.application.view.CLIENTIDS_TO_REMOVE";
    private static final String CLIENTIDS_TO_ADD_NAME = "com.sun.faces.application.view.CLIENTIDS_TO_ADD";

    public Object saveView(FacesContext context) {
        Map<String, ComponentStruct> addList;
        if (context == null) {
            return null;
        }
        UIViewRoot viewRoot = context.getViewRoot();
        if (viewRoot.isTransient()) {
            return null;
        }
        Util.checkIdUniqueness(context, (UIComponent)viewRoot, new HashSet<String>(viewRoot.getChildCount() << 1));
        HashMap<String, Object> stateMap = new HashMap<String, Object>();
        StateContext stateContext = StateContext.getStateContext(context);
        this.saveComponentState((UIComponent)viewRoot, context, stateContext, stateMap);
        List<String> removeList = stateContext.getDynamicRemoves();
        if (null != removeList && !removeList.isEmpty()) {
            stateMap.put(CLIENTIDS_TO_REMOVE_NAME, removeList);
        }
        if (null != (addList = stateContext.getDynamicAdds()) && !addList.isEmpty()) {
            ArrayList<Object> savedAddList = new ArrayList<Object>(addList.size());
            for (ComponentStruct s : addList.values()) {
                savedAddList.add(s.saveState(context));
            }
            stateMap.put(CLIENTIDS_TO_ADD_NAME, savedAddList.toArray());
        }
        return new Object[]{null, stateMap};
    }

    public UIViewRoot restoreView(FacesContext context, String viewId, String renderKitId) {
        UIViewRoot viewRoot;
        ResponseStateManager rsm = RenderKitUtils.getResponseStateManager(context, renderKitId);
        boolean processingEvents = context.isProcessingEvents();
        try {
            ViewDeclarationLanguage vdl = this.vdlFactory.getViewDeclarationLanguage(viewId);
            viewRoot = vdl.getViewMetadata(context, viewId).createMetadataView(context);
            context.setViewRoot(viewRoot);
            context.setProcessingEvents(true);
            vdl.buildView(context, viewRoot);
        }
        catch (IOException ioe) {
            throw new FacesException((Throwable)ioe);
        }
        Object[] rawState = (Object[])rsm.getState(context, viewId);
        if (rawState == null) {
            return null;
        }
        final Map state = (Map)rawState[1];
        final StateContext stateContext = StateContext.getStateContext(context);
        if (null != state) {
            Object[] restoredAddList;
            Application app = context.getApplication();
            VisitContext visitContext = VisitContext.createVisitContext((FacesContext)context);
            viewRoot.visitTree(visitContext, new VisitCallback(){

                public VisitResult visit(VisitContext context, UIComponent target) {
                    VisitResult result = VisitResult.ACCEPT;
                    String cid = target.getClientId(context.getFacesContext());
                    Object stateObj = state.get(cid);
                    if (stateObj != null && !stateContext.componentAddedDynamically(target)) {
                        try {
                            target.restoreState(context.getFacesContext(), stateObj);
                        }
                        catch (Exception e) {
                            String msg = MessageUtils.getExceptionMessageString("com.sun.faces.partial.statesaving.ERROR_RESTORING_STATE_FOR_COMPONENT", cid, e.toString());
                            throw new FacesException(msg, (Throwable)e);
                        }
                    }
                    return result;
                }
            });
            List removeList = (List)state.get(CLIENTIDS_TO_REMOVE_NAME);
            if (null != removeList && !removeList.isEmpty()) {
                for (String cur : removeList) {
                    boolean trackMods = stateContext.trackViewModifications();
                    if (trackMods) {
                        stateContext.setTrackViewModifications(false);
                    }
                    viewRoot.invokeOnComponent(context, cur, new ContextCallback(){

                        public void invokeContextCallback(FacesContext context, UIComponent target) {
                            UIComponent parent = target.getParent();
                            if (null != parent) {
                                parent.getChildren().remove(target);
                            }
                        }
                    });
                    if (!trackMods) continue;
                    stateContext.setTrackViewModifications(true);
                }
            }
            if ((restoredAddList = (Object[])state.get(CLIENTIDS_TO_ADD_NAME)) != null && restoredAddList.length > 0) {
                ArrayList<ComponentStruct> addList = new ArrayList<ComponentStruct>(restoredAddList.length);
                for (Object aRestoredAddList : restoredAddList) {
                    ComponentStruct cur = new ComponentStruct();
                    cur.restoreState(context, aRestoredAddList);
                    addList.add(cur);
                }
                Iterator i$ = addList.iterator();
                while (i$.hasNext()) {
                    ComponentStruct cur;
                    final ComponentStruct finalCur = cur = (ComponentStruct)i$.next();
                    viewRoot.invokeOnComponent(context, finalCur.parentClientId, new ContextCallback(){

                        public void invokeContextCallback(FacesContext context, UIComponent parent) {
                            StateHolderSaver saver = (StateHolderSaver)state.get(finalCur.clientId);
                            UIComponent toAdd = (UIComponent)saver.restore(context);
                            int idx = finalCur.indexOfChildInParent;
                            if (idx == -1) {
                                parent.getFacets().put(finalCur.facetName, toAdd);
                            } else {
                                try {
                                    parent.getChildren().add(finalCur.indexOfChildInParent, toAdd);
                                }
                                catch (IndexOutOfBoundsException ioobe) {
                                    if (LOGGER.isLoggable(Level.FINE)) {
                                        LOGGER.log(Level.FINE, "Unable to insert child with client ID {0} into parent with client ID {1} into list at index {2}.", new Object[]{finalCur.clientId, finalCur.parentClientId, finalCur.indexOfChildInParent});
                                    }
                                    parent.getChildren().add(toAdd);
                                }
                            }
                        }
                    });
                }
            }
        } else {
            viewRoot = null;
        }
        context.setProcessingEvents(processingEvents);
        return viewRoot;
    }

    private void saveComponentState(UIComponent c, FacesContext ctx, StateContext stateContext, Map<String, Object> stateMap) {
        if (!c.isTransient()) {
            Object stateObj = stateContext.componentAddedDynamically(c) ? new StateHolderSaver(ctx, c) : c.saveState(ctx);
            if (null != stateObj) {
                stateMap.put(c.getClientId(ctx), stateObj);
            }
            Iterator i = c.getFacetsAndChildren();
            while (i.hasNext()) {
                this.saveComponentState((UIComponent)i.next(), ctx, stateContext, stateMap);
            }
        }
    }
}

