/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.ejb3.deployers;

import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.spi.deployer.helpers.AbstractRealDeployer;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.deployers.vfs.spi.structure.VFSDeploymentUnit;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractOptionalVFSRealDeployer<T>
extends AbstractRealDeployer {
    private Class<T> optionalInput;

    public AbstractOptionalVFSRealDeployer(Class<T> optionalInput) {
        assert (optionalInput != null) : "optionalInput is null";
        this.optionalInput = optionalInput;
        this.setInputs(new Class[]{optionalInput});
    }

    public void internalDeploy(DeploymentUnit unit) throws DeploymentException {
        this.deploy(unit, unit.getAttachment(this.optionalInput));
    }

    public void deploy(DeploymentUnit unit, T deployment) throws DeploymentException {
        if (!(unit instanceof VFSDeploymentUnit)) {
            return;
        }
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        this.deploy(vfsDeploymentUnit, deployment);
    }

    public abstract void deploy(VFSDeploymentUnit var1, T var2) throws DeploymentException;

    public void internalUndeploy(DeploymentUnit unit) {
        this.undeploy(unit, unit.getAttachment(this.optionalInput));
    }

    public void undeploy(DeploymentUnit unit, T deployment) {
        if (!(unit instanceof VFSDeploymentUnit)) {
            return;
        }
        VFSDeploymentUnit vfsDeploymentUnit = (VFSDeploymentUnit)unit;
        this.undeploy(vfsDeploymentUnit, deployment);
    }

    public void undeploy(VFSDeploymentUnit unit, T deployment) {
    }
}

