/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.spi.signature;

import java.lang.reflect.Method;
import org.jboss.metadata.plugins.signature.SignatureNameUtil;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.reflect.spi.MethodInfo;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DeclaredMethodSignature
extends Signature {
    private String declaringClass;
    private Method method;
    int cachedHashCode = Integer.MIN_VALUE;

    public DeclaredMethodSignature(String declaringClass, String name, String[] parameters) {
        super(name, parameters);
        this.declaringClass = declaringClass;
    }

    public DeclaredMethodSignature(String declaringClass, String name, Class<?> ... parameters) {
        super(name, parameters);
        this.declaringClass = declaringClass;
    }

    public DeclaredMethodSignature(Method method) {
        super(method.getName(), (Class[])null);
        this.method = method;
        this.declaringClass = method.getDeclaringClass().getName();
    }

    public DeclaredMethodSignature(MethodInfo method) {
        super(method.getName(), method.getParameterTypes());
        this.declaringClass = method.getDeclaringClass().getName();
    }

    public String getDeclaringClass() {
        return this.declaringClass;
    }

    public Method getMethod() {
        return this.method;
    }

    @Override
    protected Class<?>[] getParameterTypes() {
        if (this.method != null) {
            return this.method.getParameterTypes();
        }
        return super.getParameterTypes();
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null || !super.equals(obj)) {
            return false;
        }
        if (obj instanceof DeclaredMethodSignature) {
            DeclaredMethodSignature other = (DeclaredMethodSignature)obj;
            return this.getDeclaringClass().equals(other.getDeclaringClass());
        }
        return true;
    }

    @Override
    public int hashCode() {
        if (this.cachedHashCode == Integer.MIN_VALUE) {
            StringBuilder builder = new StringBuilder();
            SignatureNameUtil.signatureToString(builder, this.getName(), this.getParameters());
            this.cachedHashCode = builder.toString().hashCode();
        }
        return this.cachedHashCode;
    }

    @Override
    protected void internalToString(StringBuilder builder) {
        super.internalToString(builder);
        builder.append(" declaring=").append(this.declaringClass);
    }
}

