/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.configuration;

import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.domain.configuration.definition.ConfigurationFormat;
import org.rhq.core.domain.resource.ResourceType;
import org.rhq.core.pc.configuration.ConfigManagement;
import org.rhq.core.pc.configuration.ConfigManagementFactory;
import org.rhq.core.pc.configuration.ConfigurationUtilityService;
import org.rhq.core.pc.configuration.ConfigurationUtilityServiceImpl;
import org.rhq.core.pc.configuration.LegacyConfigManagement;
import org.rhq.core.pc.configuration.RawConfigManagement;
import org.rhq.core.pc.configuration.StructuredAndRawConfigManagement;
import org.rhq.core.pc.configuration.StructuredConfigManagement;
import org.rhq.core.pc.util.ComponentService;
import org.rhq.core.pluginapi.configuration.ResourceConfigurationFacet;

public class ConfigManagementFactoryImpl
implements ConfigManagementFactory {
    private ComponentService componentService;
    private ConfigurationUtilityService configUtilityService = new ConfigurationUtilityServiceImpl();

    public void setComponentService(ComponentService componentService) {
        this.componentService = componentService;
    }

    public ConfigManagement getStrategy(int resourceId) throws PluginContainerException {
        ConfigManagement configManagement = this.createStrategy(resourceId);
        this.initStrategyDependencies(configManagement);
        return configManagement;
    }

    private void initStrategyDependencies(ConfigManagement configManagement) {
        configManagement.setComponentService(this.componentService);
        configManagement.setConfigurationUtilityService(this.configUtilityService);
    }

    private ConfigManagement createStrategy(int resourceId) throws PluginContainerException {
        ResourceType resourceType = this.componentService.getResourceType(resourceId);
        ConfigurationFormat format = resourceType.getResourceConfigurationDefinition().getConfigurationFormat();
        if (null == format) {
            return new LegacyConfigManagement();
        }
        switch (format) {
            case RAW: {
                return new RawConfigManagement();
            }
            case STRUCTURED_AND_RAW: {
                return new StructuredAndRawConfigManagement();
            }
        }
        if (this.componentService.fetchResourceComponent(resourceId) instanceof ResourceConfigurationFacet) {
            return new StructuredConfigManagement();
        }
        return new LegacyConfigManagement();
    }
}

