/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.core.pc.plugin;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.rhq.core.clientapi.agent.PluginContainerException;
import org.rhq.core.pluginapi.util.FileUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginClassLoader
extends URLClassLoader {
    private final Log log = LogFactory.getLog(this.getClass());
    private File embeddedJarsDirectory;
    private String stringValue;

    protected PluginClassLoader(URL[] urls, ClassLoader parent) {
        super(urls, parent);
    }

    @Override
    protected synchronized Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        try {
            Class<?> clazz = super.loadClass(name, resolve);
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Plugin class loaded: " + name));
            }
            return clazz;
        }
        catch (ClassNotFoundException cnfe) {
            if (this.log.isTraceEnabled()) {
                this.log.trace((Object)("Plugin class not found: " + name));
            }
            throw cnfe;
        }
    }

    public void destroy() {
        try {
            FileUtils.purge((File)this.embeddedJarsDirectory, (boolean)true);
        }
        catch (IOException e) {
            this.log.warn((Object)("Failed to purge embedded jars directory. Cause: " + e));
        }
        LogFactory.release((ClassLoader)this);
    }

    public static PluginClassLoader create(String pluginJarName, URL pluginUrl, boolean unpackNestedJars, ClassLoader parent, File tmpDirectory) throws PluginContainerException {
        return PluginClassLoader.create(pluginJarName, new URL[]{pluginUrl}, unpackNestedJars, parent, tmpDirectory);
    }

    public static PluginClassLoader create(String pluginJarName, URL[] pluginUrls, boolean unpackNestedJars, ClassLoader parent, File tmpDirectory) throws PluginContainerException {
        ArrayList<URL> classpathUrlList = new ArrayList<URL>();
        File unpackedDirectory = null;
        boolean processedPluginJar = false;
        for (URL pluginUrl : pluginUrls) {
            classpathUrlList.add(pluginUrl);
            if (!processedPluginJar && unpackNestedJars) {
                try {
                    unpackedDirectory = PluginClassLoader.unpackEmbeddedJars(pluginJarName, pluginUrl, classpathUrlList, tmpDirectory);
                }
                catch (Exception e) {
                    throw new PluginContainerException("Failed to unpack embedded JARs within: " + pluginUrl, (Throwable)e);
                }
            }
            processedPluginJar = true;
        }
        URL[] classpath = classpathUrlList.toArray(new URL[classpathUrlList.size()]);
        PluginClassLoader newLoader = new PluginClassLoader(classpath, parent);
        newLoader.embeddedJarsDirectory = unpackedDirectory;
        return newLoader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static File unpackEmbeddedJars(String pluginJarName, URL pluginUrl, List<URL> urls, File tmpDirectory) throws IOException {
        InputStream pluginStream = pluginUrl.openStream();
        ZipInputStream zis = new ZipInputStream(new BufferedInputStream(pluginStream));
        File extractionDirectory = null;
        block14: while (true) {
            ZipEntry entry;
            while ((entry = zis.getNextEntry()) != null) {
                int i;
                String entryName = entry.getName();
                if (!entryName.startsWith("lib") || entryName.length() <= 4) continue;
                if (extractionDirectory == null) {
                    extractionDirectory = PluginClassLoader.createTempDirectory(tmpDirectory, pluginJarName);
                }
                if ((i = entryName.lastIndexOf(47)) < 0) {
                    i = entryName.lastIndexOf(92);
                }
                String s = entryName.substring(i + 1);
                File file = null;
                try {
                    BufferedOutputStream outputStream;
                    if (s.endsWith(".jar")) {
                        file = File.createTempFile(s, null, extractionDirectory);
                        urls.add(file.toURI().toURL());
                    } else {
                        file = new File(extractionDirectory, s);
                        URL tmpUrl = extractionDirectory.toURI().toURL();
                        if (!urls.contains(tmpUrl)) {
                            urls.add(tmpUrl);
                        }
                    }
                    try {
                        outputStream = new BufferedOutputStream(new FileOutputStream(file));
                    }
                    catch (FileNotFoundException ex) {
                        if (file.exists() && file.length() > 0L) continue;
                        throw ex;
                    }
                    try {
                        file.deleteOnExit();
                        BufferedInputStream inputStream = new BufferedInputStream(zis);
                        byte[] b = new byte[8192];
                        while (true) {
                            int count;
                            if ((count = inputStream.read(b)) <= -1) continue block14;
                            outputStream.write(b, 0, count);
                        }
                    }
                    finally {
                        outputStream.flush();
                        outputStream.close();
                        continue block14;
                    }
                }
                catch (IOException ioe) {
                    if (file == null) throw ioe;
                    file.delete();
                    throw ioe;
                    return extractionDirectory;
                }
            }
        }
        finally {
            try {
                zis.close();
            }
            catch (Exception ignored) {}
        }
    }

    private static File createTempDirectory(File tmpDirectory, String pluginName) throws IOException {
        File tmpDir = File.createTempFile(pluginName, ".classloader", tmpDirectory);
        boolean deleteOk = tmpDir.delete();
        boolean mkdirsOk = tmpDir.mkdirs();
        if (!deleteOk || !mkdirsOk) {
            throw new IOException("Failed to create temp classloader directory named [" + tmpDir + "]");
        }
        tmpDir.deleteOnExit();
        return tmpDir;
    }

    public String toString() {
        if (this.stringValue == null) {
            URL[] urls = this.getURLs();
            String dir = "<>";
            if (this.embeddedJarsDirectory != null) {
                dir = this.embeddedJarsDirectory.toURI().toString();
            }
            StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName());
            stringBuilder.append('@').append(Integer.toHexString(this.hashCode())).append("[");
            stringBuilder.append("parent=").append(this.getParent()).append(",");
            stringBuilder.append("embedded-dir=[").append(dir).append("],");
            stringBuilder.append("urls=[");
            if (urls != null) {
                for (int i = 0; i < urls.length; ++i) {
                    if (i != 0) {
                        stringBuilder.append(',');
                    }
                    if (urls[i].toString().startsWith(dir)) {
                        stringBuilder.append(new File(urls[i].getPath()).getName());
                        continue;
                    }
                    stringBuilder.append(urls[i]);
                }
            }
            stringBuilder.append("]]");
            this.stringValue = stringBuilder.toString();
        }
        return this.stringValue;
    }
}

