/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.hornetq.deployers;

import java.util.Map;
import org.hornetq.api.core.management.ObjectNameBuilder;
import org.hornetq.jms.server.config.JMSConfiguration;
import org.hornetq.jms.server.config.JMSQueueConfiguration;
import org.jboss.as.integration.hornetq.deployers.pojo.HornetQConnectionFactoryDeployment;
import org.jboss.as.integration.hornetq.deployers.pojo.HornetQCoreDeployment;
import org.jboss.as.integration.hornetq.deployers.pojo.HornetQQueueDeployment;
import org.jboss.as.integration.hornetq.deployers.pojo.HornetQTopicDeployment;
import org.jboss.beans.metadata.plugins.builder.BeanMetaDataBuilderFactory;
import org.jboss.beans.metadata.spi.BeanMetaData;
import org.jboss.beans.metadata.spi.builder.BeanMetaDataBuilder;
import org.jboss.deployers.spi.DeploymentException;
import org.jboss.deployers.structure.spi.DeploymentUnit;
import org.jboss.logging.Logger;

public class DeploymentFactory {
    private static final Logger log = Logger.getLogger(DeploymentFactory.class);
    private static DeploymentFactory instance = new DeploymentFactory();

    public static DeploymentFactory getInstance() {
        return instance;
    }

    public void deployJMS(DeploymentUnit unit, JMSConfiguration mainConfig) throws DeploymentException {
        try {
            String name;
            for (JMSQueueConfiguration config : mainConfig.getQueueConfigurations()) {
                name = ObjectNameBuilder.DEFAULT.getJMSQueueObjectName(config.getName()).toString();
                unit.addAttachment(name, (Object)DeploymentFactory.createJMSBasicBean(unit, HornetQQueueDeployment.class.getName(), name, config));
            }
            for (JMSQueueConfiguration config : mainConfig.getTopicConfigurations()) {
                name = ObjectNameBuilder.DEFAULT.getJMSTopicObjectName(config.getName()).toString();
                unit.addAttachment(name, (Object)DeploymentFactory.createJMSBasicBean(unit, HornetQTopicDeployment.class.getName(), name, config));
            }
            for (JMSQueueConfiguration config : mainConfig.getConnectionFactoryConfigurations()) {
                name = "org.hornetq:module=JMS,name=\"" + config.getName() + "\",type=ConnectionFactory";
                unit.addAttachment(name, (Object)DeploymentFactory.createJMSBasicBean(unit, HornetQConnectionFactoryDeployment.class.getName(), name, config));
            }
        }
        catch (Exception e) {
            throw new DeploymentException(e.getMessage(), (Throwable)e);
        }
    }

    private static BeanMetaData createJMSBasicBean(DeploymentUnit unit, String configClass, String name, Object config) {
        BeanMetaDataBuilder builder = BeanMetaDataBuilderFactory.createBuilder((String)name, (String)configClass);
        builder.addPropertyMetaData("name", name);
        builder.addPropertyMetaData("jmsServer", builder.createInject((Object)"JMSServerManager"));
        builder.addPropertyMetaData("config", config);
        builder.addPropertyMetaData("kernel", builder.createInject((Object)"jboss.kernel:service=Kernel"));
        builder.addPropertyMetaData("mbeanServer", builder.createInject((Object)"MBeanServer"));
        for (Map.Entry entry : unit.getAttachments().entrySet()) {
            BeanMetaData checkBuilder;
            if (!(entry.getValue() instanceof BeanMetaData) || !(checkBuilder = (BeanMetaData)entry.getValue()).getBean().equals(HornetQCoreDeployment.class.getName())) continue;
            builder.addDependency(entry.getKey());
        }
        return builder.getBeanMetaData();
    }
}

