/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.hornetq.deployers.pojo;

import javax.management.MBeanServer;
import javax.management.ObjectName;
import org.jboss.as.integration.hornetq.management.HornetQControlRuntimeDispatchPlugin;
import org.jboss.kernel.Kernel;
import org.jboss.kernel.spi.registry.KernelRegistry;
import org.jboss.kernel.spi.registry.KernelRegistryEntry;
import org.jboss.logging.Logger;

public class AbstractHornetQControlReferenceDeployment {
    private static final Logger log = Logger.getLogger((String)"org.jboss.as.integration.hornetq.management");
    private Kernel kernel;
    private MBeanServer mbeanServer;

    public Kernel getKernel() {
        return this.kernel;
    }

    public void setKernel(Kernel kernel) {
        this.kernel = kernel;
    }

    public MBeanServer getMbeanServer() {
        return this.mbeanServer;
    }

    public void setMbeanServer(MBeanServer mbeanServer) {
        this.mbeanServer = mbeanServer;
    }

    protected void registerControlReference(ObjectName objectName) {
        try {
            this.getKernelRegistry().registerEntry((Object)objectName, (KernelRegistryEntry)new HornetQControlRuntimeDispatchPlugin(objectName, this.mbeanServer));
        }
        catch (Exception e) {
            log.debug((Object)"failed to register hornetQ control runtime dispatcher plugin", (Throwable)e);
        }
    }

    protected void unregisterControlReference(ObjectName objectName) {
        try {
            this.getKernelRegistry().unregisterEntry((Object)objectName);
        }
        catch (Exception e) {
            log.debug((Object)"failed to unregister hornetQ control runtime dispatcher plugin", (Throwable)e);
        }
    }

    protected KernelRegistry getKernelRegistry() {
        if (this.kernel == null) {
            throw new IllegalStateException("null kernel");
        }
        return this.kernel.getRegistry();
    }
}

