/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.integration.hornetq.management.template;

import java.io.File;
import java.io.FileWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Arrays;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import org.jboss.as.integration.hornetq.management.template.HornetQDestinationTemplateInfo;
import org.jboss.as.integration.hornetq.management.template.JAXBJMSConfiguration;
import org.jboss.as.integration.hornetq.management.template.JAXBJMSQueueConfiguration;
import org.jboss.as.integration.hornetq.management.template.JAXBJMSTopicConfiguration;
import org.jboss.deployers.spi.management.DeploymentTemplate;
import org.jboss.managed.api.DeploymentTemplateInfo;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.MetaValueFactory;
import org.jboss.metatype.api.values.SimpleValue;
import org.jboss.metatype.plugins.values.MetaValueFactoryBuilder;
import org.jboss.vfs.VFS;
import org.jboss.vfs.VirtualFile;

public class HornetQDestinationTemplate
implements DeploymentTemplate {
    private static final String FILE_SUFFIX = "hornetq-jms.xml";
    protected static final String[] attributes = new String[]{"read", "write", "create"};
    private static final MetaValueFactory mvf = MetaValueFactoryBuilder.create();
    private DeploymentTemplateInfo info;

    public VirtualFile applyTemplate(DeploymentTemplateInfo info) throws Exception {
        File xml = File.createTempFile(this.getClass().getSimpleName(), FILE_SUFFIX);
        this.writeTemplate(xml, info);
        return VFS.getChild((URI)xml.toURI());
    }

    public String getDeploymentName(String deploymentBaseName) {
        if (deploymentBaseName == null) {
            throw new IllegalArgumentException("Null base name.");
        }
        if (!deploymentBaseName.endsWith(FILE_SUFFIX)) {
            deploymentBaseName = deploymentBaseName + FILE_SUFFIX;
        }
        return deploymentBaseName;
    }

    public DeploymentTemplateInfo getInfo() {
        return this.info;
    }

    public void setInfo(DeploymentTemplateInfo info) {
        this.info = info;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeTemplate(File xml, DeploymentTemplateInfo info) throws Exception {
        if (info == null) {
            throw new IllegalArgumentException("Null template info.");
        }
        if (info.getProperties() == null) {
            throw new IllegalArgumentException("Null template info.");
        }
        JAXBJMSConfiguration config = new JAXBJMSConfiguration();
        ManagedProperty destTypeMP = (ManagedProperty)info.getProperties().get("destinationType");
        String destinationType = null;
        if (destTypeMP == null) {
            destinationType = ((HornetQDestinationTemplateInfo)info).getDestinationType();
        } else {
            SimpleValue dsTypeSV = (SimpleValue)destTypeMP.getValue();
            destinationType = dsTypeSV.getValue().toString();
        }
        String destinationName = (String)this.getProperty(info, "name");
        if (destinationName == null) {
            throw new IllegalStateException("Destination name has not been specified!");
        }
        String[] bindings = (String[])this.getProperty(info, "bindings");
        if (bindings == null) {
            throw new IllegalStateException("bindings have not been specified!");
        }
        if ("QueueTemplate".equals(destinationType)) {
            JAXBJMSQueueConfiguration queue = new JAXBJMSQueueConfiguration();
            config.setQueueConfigurations(Arrays.asList(queue));
            queue.setName(destinationName);
            queue.setBindings(bindings);
        } else if ("TopicTemplate".equals(destinationType)) {
            JAXBJMSTopicConfiguration topic = new JAXBJMSTopicConfiguration();
            config.setTopicConfigurations(Arrays.asList(topic));
            topic.setName(destinationName);
            topic.setBindings(bindings);
        } else {
            throw new IllegalStateException("Unsupported destination type: " + destinationType);
        }
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{JAXBJMSConfiguration.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
        JAXBElement root = new JAXBElement(new QName("urn:hornetq", "configuration"), JAXBJMSConfiguration.class, null, (Object)config);
        FileWriter fw = null;
        try {
            fw = new FileWriter(xml);
            marshaller.marshal((Object)root, (Writer)fw);
        }
        finally {
            if (fw != null) {
                ((Writer)fw).close();
            }
        }
    }

    private Object getProperty(DeploymentTemplateInfo info, String propName) {
        Map propsInfo = info.getProperties();
        ManagedProperty prop = (ManagedProperty)propsInfo.get(propName);
        if (prop == null) {
            return null;
        }
        MetaValue value = prop.getValue();
        if (value instanceof MetaValue) {
            return mvf.unwrap(value);
        }
        return value;
    }
}

