/*
 * Decompiled with CFR 0.152.
 */
package org.jacorb.ir.gui.typesystem.remote;

import java.util.Enumeration;
import java.util.Vector;
import org.jacorb.ir.gui.typesystem.Interface;
import org.jacorb.ir.gui.typesystem.ModelParticipant;
import org.jacorb.ir.gui.typesystem.TypeSystemNode;
import org.jacorb.ir.gui.typesystem.remote.IRAttribute;
import org.jacorb.ir.gui.typesystem.remote.IRConstant;
import org.jacorb.ir.gui.typesystem.remote.IRContainer;
import org.jacorb.ir.gui.typesystem.remote.IRException;
import org.jacorb.ir.gui.typesystem.remote.IROperation;
import org.jacorb.ir.gui.typesystem.remote.IRTypedef;
import org.jacorb.ir.gui.typesystem.remote.RemoteTypeSystem;
import org.omg.CORBA.IRObject;
import org.omg.CORBA.InterfaceDef;
import org.omg.CORBA.InterfaceDefHelper;

public class IRInterface
extends IRContainer
implements Interface {
    private IRInterface[] superInterfaces = null;
    private IRAttribute[] allFields = null;
    private IROperation[] allOperations = null;

    public IRInterface() {
    }

    public IRInterface(IRObject iRObject) {
        super(iRObject);
    }

    public String[] allowedToAdd() {
        String[] stringArray = new String[]{IRAttribute.nodeTypeName(), IROperation.nodeTypeName(), IRConstant.nodeTypeName(), IRTypedef.nodeTypeName(), IRException.nodeTypeName()};
        return stringArray;
    }

    public String description() {
        String string = super.description();
        Interface[] interfaceArray = this.getSuperInterfaces();
        if (interfaceArray.length > 0) {
            string = string + "\nSuper-Interfaces:\t ";
            for (int i = 0; i < interfaceArray.length; ++i) {
                string = string + ((TypeSystemNode)((Object)interfaceArray[i])).getAbsoluteName();
                if (i == interfaceArray.length - 1) continue;
                string = string + ", ";
            }
        } else {
            string = string + "\nSuper-Interfaces:\t:none";
        }
        return string;
    }

    public TypeSystemNode[] getAllFields() {
        if (this.allFields == null) {
            int n;
            Vector<ModelParticipant> vector = new Vector<ModelParticipant>();
            Interface[] interfaceArray = this.getSuperInterfaces();
            for (int i = 0; i < interfaceArray.length; ++i) {
                TypeSystemNode[] typeSystemNodeArray = interfaceArray[i].getAllFields();
                for (int j = 0; j < typeSystemNodeArray.length; ++j) {
                    vector.addElement(typeSystemNodeArray[j]);
                }
            }
            ModelParticipant[] modelParticipantArray = this.contents();
            for (n = 0; n < modelParticipantArray.length; ++n) {
                if (!(modelParticipantArray[n] instanceof IRAttribute)) continue;
                vector.addElement(modelParticipantArray[n]);
            }
            this.allFields = new IRAttribute[vector.size()];
            n = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.allFields[n] = (IRAttribute)enumeration.nextElement();
                ++n;
            }
        }
        return this.allFields;
    }

    public TypeSystemNode[] getAllOperations() {
        if (this.allOperations == null) {
            int n;
            Vector<ModelParticipant> vector = new Vector<ModelParticipant>();
            Interface[] interfaceArray = this.getSuperInterfaces();
            for (int i = 0; i < interfaceArray.length; ++i) {
                TypeSystemNode[] typeSystemNodeArray = interfaceArray[i].getAllOperations();
                for (int j = 0; j < typeSystemNodeArray.length; ++j) {
                    vector.addElement(typeSystemNodeArray[j]);
                }
            }
            ModelParticipant[] modelParticipantArray = this.contents();
            for (n = 0; n < modelParticipantArray.length; ++n) {
                if (!(modelParticipantArray[n] instanceof IROperation)) continue;
                vector.addElement(modelParticipantArray[n]);
            }
            this.allOperations = new IROperation[vector.size()];
            n = 0;
            Enumeration enumeration = vector.elements();
            while (enumeration.hasMoreElements()) {
                this.allOperations[n] = (IROperation)enumeration.nextElement();
                ++n;
            }
        }
        return this.allOperations;
    }

    public Interface[] getSuperInterfaces() {
        if (this.superInterfaces == null) {
            InterfaceDef interfaceDef = InterfaceDefHelper.narrow(this.irObject);
            InterfaceDef[] interfaceDefArray = interfaceDef.base_interfaces();
            this.superInterfaces = new IRInterface[interfaceDefArray.length];
            for (int i = 0; i < interfaceDefArray.length; ++i) {
                IRInterface iRInterface;
                this.superInterfaces[i] = iRInterface = (IRInterface)RemoteTypeSystem.createTypeSystemNode(interfaceDefArray[i]);
            }
        }
        return this.superInterfaces;
    }

    public static String nodeTypeName() {
        return "interface";
    }

    protected void setIRObject(IRObject iRObject) {
        super.setIRObject(iRObject);
    }
}

