/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.xnio.nio;

import java.io.Closeable;
import java.io.IOException;
import java.net.DatagramSocket;
import java.net.InetSocketAddress;
import java.nio.channels.Channel;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.DatagramChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Executor;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.management.NotCompliantMBeanException;
import javax.management.StandardMBean;
import org.jboss.xnio.ChannelListener;
import org.jboss.xnio.FailedIoFuture;
import org.jboss.xnio.IoFuture;
import org.jboss.xnio.IoUtils;
import org.jboss.xnio.Option;
import org.jboss.xnio.OptionMap;
import org.jboss.xnio.Options;
import org.jboss.xnio.UdpServer;
import org.jboss.xnio.channels.Configurable;
import org.jboss.xnio.channels.UdpChannel;
import org.jboss.xnio.channels.UnsupportedOptionException;
import org.jboss.xnio.log.Logger;
import org.jboss.xnio.management.UdpServerMBean;
import org.jboss.xnio.nio.FutureUdpChannel;
import org.jboss.xnio.nio.NioUdpChannel;
import org.jboss.xnio.nio.NioXnio;

class NioUdpServer
implements UdpServer {
    private static final Logger log = Logger.getLogger((String)"org.jboss.xnio.nio.udp.server");
    private final NioXnio nioXnio;
    private final Executor executor;
    private final Object lock = new Object();
    private final Set<NioUdpChannel> boundChannels = new LinkedHashSet<NioUdpChannel>();
    private volatile ChannelListener<? super UdpChannel> bindListener = null;
    private volatile ChannelListener<? super UdpServer> closeListener = null;
    private static final AtomicReferenceFieldUpdater<NioUdpServer, ChannelListener> bindListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(NioUdpServer.class, ChannelListener.class, "bindListener");
    private static final AtomicReferenceFieldUpdater<NioUdpServer, ChannelListener> closeListenerUpdater = AtomicReferenceFieldUpdater.newUpdater(NioUdpServer.class, ChannelListener.class, "closeListener");
    private final ChannelListener.Setter<UdpChannel> bindSetter = IoUtils.getSetter((Object)this, bindListenerUpdater);
    private final ChannelListener.Setter<UdpServer> closeSetter = IoUtils.getSetter((Object)this, closeListenerUpdater);
    private boolean closed;
    private Boolean reuseAddress;
    private Integer receiveBufferSize;
    private Integer sendBufferSize;
    private Integer trafficClass;
    private Boolean broadcast;
    private final Closeable mbeanHandle;
    private final AtomicLong globalBytesRead = new AtomicLong();
    private final AtomicLong globalBytesWritten = new AtomicLong();
    private final AtomicLong globalMessagesRead = new AtomicLong();
    private final AtomicLong globalMessagesWritten = new AtomicLong();
    protected static final Set<Option<?>> OPTIONS = Option.setBuilder().add(Options.RECEIVE_BUFFER).add(Options.REUSE_ADDRESSES).add(Options.SEND_BUFFER).add(Options.IP_TRAFFIC_CLASS).add(Options.BROADCAST).create();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NioUdpServer(NioXnio nioXnio, Executor executor, ChannelListener<? super UdpChannel> bindListener, OptionMap optionMap) {
        Object object = this.lock;
        synchronized (object) {
            this.nioXnio = nioXnio;
            this.executor = executor;
            this.bindListener = bindListener;
            this.reuseAddress = (Boolean)optionMap.get(Options.REUSE_ADDRESSES);
            this.receiveBufferSize = (Integer)optionMap.get(Options.RECEIVE_BUFFER);
            this.receiveBufferSize = (Integer)optionMap.get(Options.RECEIVE_BUFFER);
            this.sendBufferSize = (Integer)optionMap.get(Options.SEND_BUFFER);
            this.trafficClass = (Integer)optionMap.get(Options.IP_TRAFFIC_CLASS);
            this.broadcast = (Boolean)optionMap.get(Options.BROADCAST);
            Closeable closeable = IoUtils.nullCloseable();
            try {
                closeable = nioXnio.registerMBean(new MBean());
            }
            catch (NotCompliantMBeanException e) {
                log.trace((Throwable)e, "Failed to register MBean", new Object[0]);
            }
            this.mbeanHandle = closeable;
        }
    }

    public boolean supportsOption(Option<?> option) {
        return OPTIONS.contains(option);
    }

    public <T> T getOption(Option<T> option) throws UnsupportedOptionException, IOException {
        if (Options.RECEIVE_BUFFER.equals(option)) {
            return (T)option.cast((Object)this.receiveBufferSize);
        }
        if (Options.REUSE_ADDRESSES.equals(option)) {
            return (T)option.cast((Object)this.reuseAddress);
        }
        if (Options.SEND_BUFFER.equals(option)) {
            return (T)option.cast((Object)this.sendBufferSize);
        }
        if (Options.IP_TRAFFIC_CLASS.equals(option)) {
            return (T)option.cast((Object)this.trafficClass);
        }
        if (Options.BROADCAST.equals(option)) {
            return (T)option.cast((Object)this.broadcast);
        }
        return null;
    }

    public <T> Configurable setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (Options.RECEIVE_BUFFER.equals(option)) {
            this.receiveBufferSize = (Integer)Options.RECEIVE_BUFFER.cast(value);
        } else if (Options.REUSE_ADDRESSES.equals(option)) {
            this.reuseAddress = (Boolean)Options.REUSE_ADDRESSES.cast(value);
        } else if (Options.SEND_BUFFER.equals(option)) {
            this.sendBufferSize = (Integer)Options.SEND_BUFFER.cast(value);
        } else if (Options.IP_TRAFFIC_CLASS.equals(option)) {
            this.trafficClass = (Integer)Options.IP_TRAFFIC_CLASS.cast(value);
        } else if (Options.BROADCAST.equals(option)) {
            this.broadcast = (Boolean)Options.BROADCAST.cast(value);
        }
        return this;
    }

    public ChannelListener.Setter<UdpChannel> getBindSetter() {
        return this.bindSetter;
    }

    public ChannelListener.Setter<UdpServer> getCloseSetter() {
        return this.closeSetter;
    }

    public String toString() {
        return String.format("UDP server (NIO) <%s>", Integer.toHexString(this.hashCode()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<UdpChannel> getChannels() {
        Object object = this.lock;
        synchronized (object) {
            return new ArrayList<UdpChannel>(this.boundChannels);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IoFuture<UdpChannel> bind(final InetSocketAddress address) {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.closed) {
                    throw new ClosedChannelException();
                }
                final DatagramChannel datagramChannel = DatagramChannel.open();
                datagramChannel.configureBlocking(false);
                DatagramSocket socket = datagramChannel.socket();
                if (this.broadcast != null) {
                    socket.setBroadcast(this.broadcast);
                }
                if (this.receiveBufferSize != null) {
                    socket.setReceiveBufferSize(this.receiveBufferSize);
                }
                if (this.sendBufferSize != null) {
                    socket.setSendBufferSize(this.sendBufferSize);
                }
                if (this.reuseAddress != null) {
                    socket.setReuseAddress(this.reuseAddress);
                }
                if (this.trafficClass != null) {
                    socket.setTrafficClass(this.trafficClass);
                }
                socket.bind(address);
                final NioUdpChannel udpSocketChannel = this.createChannel(datagramChannel);
                final FutureUdpChannel futureUdpChannel = new FutureUdpChannel(udpSocketChannel, datagramChannel);
                this.boundChannels.add(udpSocketChannel);
                this.executor.execute(new Runnable(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        block6: {
                            try {
                                IoUtils.invokeChannelListener((Channel)((Object)udpSocketChannel), (ChannelListener)NioUdpServer.this.bindListener);
                                if (!futureUdpChannel.done()) {
                                    IoUtils.safeClose((Closeable)((Object)udpSocketChannel));
                                }
                                log.trace("Successfully bound to %s on %s", (Object)address, (Object)NioUdpServer.this);
                            }
                            catch (Throwable t) {
                                IoUtils.safeClose((Closeable)datagramChannel);
                                Object object = NioUdpServer.this.lock;
                                synchronized (object) {
                                    NioUdpServer.this.boundChannels.remove(udpSocketChannel);
                                }
                                IOException ioe = new IOException("Failed to open UDP channel: " + t.toString());
                                ioe.initCause(t);
                                if (futureUdpChannel.setException(ioe)) break block6;
                                log.trace((Throwable)ioe, "UDP channel open failed, but the operation was cancelled before the exception could be relayed", new Object[0]);
                            }
                        }
                    }
                });
                return futureUdpChannel;
            }
            catch (IOException e) {
                return new FailedIoFuture(e);
            }
        }
    }

    NioUdpChannel createChannel(DatagramChannel datagramChannel) throws IOException {
        return new NioUdpChannel(this.nioXnio, datagramChannel, this.executor, this.globalBytesRead, this.globalBytesWritten, this.globalMessagesRead, this.globalMessagesWritten);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isOpen() {
        Object object = this.lock;
        synchronized (object) {
            return !this.closed;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (!this.closed) {
                log.trace("Closing %s", (Object)this);
                this.closed = true;
                Iterator<NioUdpChannel> it = this.boundChannels.iterator();
                while (it.hasNext()) {
                    IoUtils.safeClose((Closeable)((Closeable)((Object)it.next())));
                    it.remove();
                }
                IoUtils.safeClose((Closeable)this.mbeanHandle);
                IoUtils.invokeChannelListener((Executor)this.executor, (Channel)((Object)this), this.closeListener);
            }
        }
    }

    private final class MBean
    extends StandardMBean
    implements UdpServerMBean {
        private MBean() throws NotCompliantMBeanException {
            super(UdpServerMBean.class);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public UdpServerMBean.Channel[] getBoundChannels() {
            Object object = NioUdpServer.this.lock;
            synchronized (object) {
                UdpServerMBean.Channel[] channels = new UdpServerMBean.Channel[NioUdpServer.this.boundChannels.size()];
                int i = 0;
                for (final NioUdpChannel channel : NioUdpServer.this.boundChannels) {
                    channels[i++] = new UdpServerMBean.Channel(){

                        public long getBytesRead() {
                            return channel.bytesRead.get();
                        }

                        public long getBytesWritten() {
                            return channel.bytesWritten.get();
                        }

                        public long getMessagesRead() {
                            return channel.messagesRead.get();
                        }

                        public long getMessagesWritten() {
                            return channel.messagesWritten.get();
                        }

                        public InetSocketAddress getBindAddress() {
                            InetSocketAddress lsa = channel.getLocalAddress();
                            if (lsa == null) {
                                return new InetSocketAddress(0);
                            }
                            return lsa;
                        }

                        public void close() {
                            IoUtils.safeClose((Closeable)((Object)channel));
                        }
                    };
                }
                return channels;
            }
        }

        public long getBytesRead() {
            return NioUdpServer.this.globalBytesRead.get();
        }

        public long getBytesWritten() {
            return NioUdpServer.this.globalBytesWritten.get();
        }

        public long getMessagesRead() {
            return NioUdpServer.this.globalMessagesRead.get();
        }

        public long getMessagesWritten() {
            return NioUdpServer.this.globalMessagesWritten.get();
        }

        public void close() {
            IoUtils.safeClose((Closeable)((Object)NioUdpServer.this));
        }
    }
}

