/*
 * Decompiled with CFR 0.152.
 */
package org.rhq.plugins.jbossas5.adapter.impl.configuration;

import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jboss.managed.api.ManagedObject;
import org.jboss.managed.api.ManagedProperty;
import org.jboss.managed.plugins.ManagedObjectImpl;
import org.jboss.managed.plugins.ManagedPropertyImpl;
import org.jboss.metatype.api.types.GenericMetaType;
import org.jboss.metatype.api.types.MetaType;
import org.jboss.metatype.api.values.EnumValue;
import org.jboss.metatype.api.values.GenericValue;
import org.jboss.metatype.api.values.GenericValueSupport;
import org.jboss.metatype.api.values.MetaValue;
import org.jboss.metatype.api.values.SimpleValue;
import org.rhq.core.domain.configuration.Property;
import org.rhq.core.domain.configuration.PropertyMap;
import org.rhq.core.domain.configuration.PropertySimple;
import org.rhq.core.domain.configuration.definition.PropertyDefinition;
import org.rhq.core.domain.configuration.definition.PropertyDefinitionMap;
import org.rhq.plugins.jbossas5.adapter.api.AbstractPropertyMapAdapter;
import org.rhq.plugins.jbossas5.adapter.api.PropertyAdapter;
import org.rhq.plugins.jbossas5.adapter.api.PropertyAdapterFactory;
import org.rhq.plugins.jbossas5.util.ConversionUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyMapToGenericValueAdapter
extends AbstractPropertyMapAdapter
implements PropertyAdapter<PropertyMap, PropertyDefinitionMap> {
    private final Log log = LogFactory.getLog(this.getClass());

    @Override
    public void populateMetaValueFromProperty(PropertyMap propMap, MetaValue metaValue, PropertyDefinitionMap propDefMap) {
        GenericValue genericValue = (GenericValue)metaValue;
        if (!(genericValue.getValue() instanceof ManagedObject)) {
            this.log.error((Object)("GenericValue's value [" + genericValue.getValue() + "] is not a ManagedObject - not supported!"));
            return;
        }
        ManagedObject managedObject = (ManagedObject)genericValue.getValue();
        for (String propName : propMap.getMap().keySet()) {
            MetaValue managedPropMetaValue;
            Property mapMemberProp = propMap.get(propName);
            ManagedProperty managedProp = managedObject.getProperty(propName);
            MetaType metaType = managedProp.getMetaType();
            PropertyAdapter propertyAdapter = PropertyAdapterFactory.getPropertyAdapter(metaType);
            PropertyDefinition mapMemberPropDef = propDefMap.get(propName);
            if (managedProp.getValue() == null) {
                managedPropMetaValue = propertyAdapter.convertToMetaValue(mapMemberProp, mapMemberPropDef, metaType);
                managedProp.setValue(managedPropMetaValue);
                continue;
            }
            managedPropMetaValue = managedProp.getValue();
            propertyAdapter.populateMetaValueFromProperty(mapMemberProp, managedPropMetaValue, mapMemberPropDef);
        }
    }

    @Override
    public MetaValue convertToMetaValue(PropertyMap propMap, PropertyDefinitionMap propDefMap, MetaType metaType) {
        ManagedObjectImpl managedObject = new ManagedObjectImpl(propDefMap.getName());
        for (PropertyDefinition mapMemberPropDef : propDefMap.getPropertyDefinitions().values()) {
            ManagedPropertyImpl managedProp = new ManagedPropertyImpl(mapMemberPropDef.getName());
            MetaType managedPropMetaType = ConversionUtils.convertPropertyDefinitionToMetaType(mapMemberPropDef);
            managedProp.setMetaType(managedPropMetaType);
            managedProp.setManagedObject((ManagedObject)managedObject);
            managedObject.getProperties().put(managedProp.getName(), managedProp);
        }
        GenericValueSupport genericValue = new GenericValueSupport(new GenericMetaType(propDefMap.getName(), propDefMap.getDescription()), (Serializable)managedObject);
        this.populateMetaValueFromProperty(propMap, (MetaValue)genericValue, propDefMap);
        return genericValue;
    }

    @Override
    public void populatePropertyFromMetaValue(PropertyMap propMap, MetaValue metaValue, PropertyDefinitionMap propDefMap) {
        GenericValue genericValue = (GenericValue)metaValue;
        ManagedObject managedObject = (ManagedObject)genericValue.getValue();
        for (String propName : propDefMap.getPropertyDefinitions().keySet()) {
            Object value;
            ManagedProperty managedProp = managedObject.getProperty(propName);
            if (managedProp == null) continue;
            MetaType metaType = managedProp.getMetaType();
            if (metaType.isSimple()) {
                SimpleValue simpleValue = (SimpleValue)managedProp.getValue();
                value = simpleValue.getValue();
            } else if (metaType.isEnum()) {
                EnumValue enumValue = (EnumValue)managedProp.getValue();
                value = enumValue.getValue();
            } else {
                this.log.error((Object)("Nested ManagedProperty's value [" + managedProp.getValue() + "] is not a SimpleValue or EnumValue - unsupported!"));
                continue;
            }
            propMap.put((Property)new PropertySimple(propName, value));
        }
    }
}

