/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.metadata.annotation.creator.ejb.jboss;

import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collection;
import org.jboss.ejb3.annotation.CacheConfig;
import org.jboss.metadata.annotation.creator.AbstractFinderUser;
import org.jboss.metadata.annotation.creator.Processor;
import org.jboss.metadata.annotation.creator.ProcessorUtils;
import org.jboss.metadata.annotation.finder.AnnotationFinder;
import org.jboss.metadata.ejb.jboss.CacheConfigMetaData;
import org.jboss.metadata.ejb.jboss.JBossSessionBeanMetaData;

public class JBossCacheConfigProcessor
extends AbstractFinderUser
implements Processor<JBossSessionBeanMetaData, Class<?>> {
    protected JBossCacheConfigProcessor(AnnotationFinder<AnnotatedElement> finder) {
        super(finder);
    }

    public void process(JBossSessionBeanMetaData metaData, Class<?> type) {
        CacheConfig annotation = (CacheConfig)this.finder.getAnnotation(type, CacheConfig.class);
        if (annotation == null) {
            return;
        }
        CacheConfigMetaData cacheConfig = new CacheConfigMetaData();
        cacheConfig.setMaxSize(annotation.maxSize());
        cacheConfig.setName(annotation.name());
        cacheConfig.setIdleTimeoutSeconds((int)annotation.idleTimeoutSeconds());
        cacheConfig.setRemoveTimeoutSeconds((int)annotation.removalTimeoutSeconds());
        cacheConfig.setReplicationIsPassivation(Boolean.toString(annotation.replicationIsPassivation()));
        metaData.setCacheConfig(cacheConfig);
    }

    public Collection<Class<? extends Annotation>> getAnnotationTypes() {
        return ProcessorUtils.createAnnotationSet(CacheConfig.class);
    }
}

