/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.jtype;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Type;
import org.hibernate.validator.jtype.ClassSerializer;
import org.hibernate.validator.jtype.ClassSerializers;
import org.hibernate.validator.jtype.TypeUtils;
import org.hibernate.validator.jtype.Utils;

class DefaultGenericArrayType
implements GenericArrayType {
    private final Type componentType;

    public DefaultGenericArrayType(Type componentType) {
        this.componentType = Utils.checkNotNull(componentType, "componentType");
    }

    public Type getGenericComponentType() {
        return this.componentType;
    }

    public int hashCode() {
        return this.componentType.hashCode();
    }

    public boolean equals(Object object) {
        if (!(object instanceof GenericArrayType)) {
            return false;
        }
        GenericArrayType type = (GenericArrayType)object;
        return this.componentType.equals(type.getGenericComponentType());
    }

    public String toString() {
        return DefaultGenericArrayType.toString(this);
    }

    public static String toString(GenericArrayType type) {
        return DefaultGenericArrayType.toString(type, ClassSerializers.QUALIFIED);
    }

    public static String toString(GenericArrayType type, ClassSerializer serializer) {
        return TypeUtils.toString(type.getGenericComponentType(), serializer) + "[]";
    }
}

