/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.scanning.annotations.plugins;

import java.lang.annotation.Annotation;
import java.lang.annotation.ElementType;
import java.net.URL;
import org.jboss.classloading.spi.visitor.ClassFilter;
import org.jboss.classloading.spi.visitor.ResourceFilter;
import org.jboss.metadata.spi.signature.Signature;
import org.jboss.reflect.spi.AnnotationValue;
import org.jboss.reflect.spi.ClassInfo;
import org.jboss.reflect.spi.InterfaceInfo;
import org.jboss.scanning.annotations.plugins.MutableAnnotationRepository;
import org.jboss.scanning.plugins.helpers.ResourceOwnerFinder;
import org.jboss.scanning.plugins.visitor.ClassHierarchyResourceVisitor;
import org.jboss.scanning.plugins.visitor.ReflectProvider;

public class GenericAnnotationVisitor
extends ClassHierarchyResourceVisitor {
    private MutableAnnotationRepository repository;

    public GenericAnnotationVisitor(ReflectProvider provider, ResourceOwnerFinder finder, MutableAnnotationRepository repository) {
        super(provider, finder);
        if (repository == null) {
            throw new IllegalArgumentException("Null repository");
        }
        this.repository = repository;
    }

    protected boolean isRelevant(ClassInfo classInfo) {
        return !this.repository.isAlreadyChecked(classInfo.getName());
    }

    public ResourceFilter getFilter() {
        return ClassFilter.INSTANCE;
    }

    protected void handleRelevantClass(ClassInfo classInfo, URL ownerURL) {
        InterfaceInfo[] interfaces = classInfo.getInterfaces();
        if (interfaces != null && interfaces.length > 0) {
            String className = classInfo.getName();
            for (InterfaceInfo intf : interfaces) {
                for (AnnotationValue val : intf.getAnnotations()) {
                    String annotation = val.getAnnotationType().getName();
                    this.repository.addClassImplementingInterfaceAnnotatedWith(annotation, className);
                }
            }
        }
    }

    protected void handleAnnotations(ElementType type, Signature signature, Annotation[] annotations, String className, URL ownerURL) {
        if (annotations != null && annotations.length > 0) {
            for (Annotation annotation : annotations) {
                this.repository.putAnnotation(annotation, type, className, signature, ownerURL);
            }
        }
    }
}

